/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NavigateAction
extends AbstractSelectionAwareAction {
    private IWorkbenchPage myActivePage;

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                Iterator elements = NavigateAction.super.selectedModelElementsIterator();
                while (elements.hasNext()) {
                    Element curElement = (Element)elements.next();
                    if (!curElement.hasProperty("$source")) continue;
                    NavigateAction.navigate(curElement, NavigateAction.this.myActivePage);
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.getSelection() == null) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                return element.hasProperty("$source");
            }
        });
    }

    private static void navigate(Element element, IWorkbenchPage page) {
        ModelUIPlugin.getDefault().openEditor(element, page, true);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.myActivePage = targetPart.getSite().getPage();
    }
}

