/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.HashMap;
import java.util.Map;

public class InplaceEditorPropertyProvider
implements PropertyGetProvider,
PropertySetProvider,
ModelAware {
    public static final String INVOKE_INPLACE = "#invoke_inplace";
    public static final String INVOKE_INPLACE_PARENT_UIN = "#invoke_inplace_parent_uin";
    private Map myProperties;

    public void registered(Model model) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
    }

    public void unregistered(Model model) {
        if (this.myProperties != null) {
            this.myProperties = null;
        }
    }

    public String getPropertyValue(Element element, String propertyName) {
        Property result = (Property)this.myProperties.get(element.getUniqueName());
        return result == null ? null : result.getValue();
    }

    public Property getProperty(Element element, String propertyName) {
        return (Property)this.myProperties.get(element.getUniqueName());
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getProperty(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return !(element instanceof Reference);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        PropertyWithSubProperties result = new PropertyWithSubProperties(propertyName, propertyValue, element);
        this.myProperties.put(element.getUniqueName(), result);
        return result;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue != null) {
            this.addProperty(element, propertyName, propertyValue);
        } else {
            this.myProperties.remove(element.getUniqueName());
        }
    }

    private static class PropertyWithSubProperties
    extends PropertyAdapter
    implements Property {
        private PropertyMap mySubProperties;

        public PropertyWithSubProperties(String propertyName, String propertyValue, Element owner) {
            super(propertyName, propertyValue, owner);
            this.mySubProperties = owner.getModel().createReferenceTemplate();
        }

        public PropertyMap getSubproperties() {
            return this.mySubProperties;
        }
    }
}

