/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.internal.model.ui.IHack;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import com.tssap.selena.model.ui.actions.common.ClipBoardBuffer;
import com.tssap.selena.model.ui.actions.common.CutCopyActionFilterHelper;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;
import com.tssap.selena.model.util.Assert;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;

public class CutElementAction
extends AbstractSelectionAwareAction
implements IHack {
    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                ClipBoardBuffer.clear();
                Iterator wrappers = CutElementAction.super.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    IElementWrapper nextWrapper = (IElementWrapper)wrappers.next();
                    if (CutElementAction.isShortcut(nextWrapper)) {
                        CutElementAction.this.runForShortcut(nextWrapper);
                        continue;
                    }
                    CutElementAction.this.runForRegular(nextWrapper);
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.changesIsDisabled()) {
            return false;
        }
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryWrapperCondition(){

            public boolean check(DefaultElementWrapper wrapper) {
                return CutElementAction.this.checkActionFiltersFromXML(wrapper) && (CutElementAction.isShortcut(wrapper) ? CutElementAction.this.canRunForShortcut(wrapper) : CutElementAction.this.canRunForRegular(wrapper));
            }
        });
    }

    private static boolean isShortcut(IElementWrapper wrapper) {
        return wrapper.getOriginalElement() instanceof Reference && wrapper.getOriginalElement().hasProperty("$imported");
    }

    private void runForShortcut(final IElementWrapper wrapper) {
        Assert.isLegal((boolean)CutElementAction.isShortcut(wrapper));
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                if (wrapper.getResolvedElement() != null) {
                    Entity toCopy = CutElementAction.access$701(wrapper.getResolvedElement());
                    if (toCopy == null) {
                        return;
                    }
                    TreeReferenceTemplate treeTemplate = ClipBoardBuffer.createTreeReferenceTemplate(wrapper);
                    Entity copied = toCopy.copy();
                    if (copied != null) {
                        ClipBoardBuffer.setClipboardCopy(copied, treeTemplate);
                        wrapper.getOriginalElement().delete();
                    }
                }
            }
        });
    }

    private void runForRegular(final IElementWrapper wrapper) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                if (wrapper.getResolvedElement() != null) {
                    Entity toCut = CutElementAction.access$801(wrapper.getResolvedElement());
                    if (toCut == null) {
                        return;
                    }
                    TreeReferenceTemplate treeTemplate = ClipBoardBuffer.createTreeReferenceTemplate(wrapper);
                    Entity cuttedCopy = toCut.cut();
                    if (cuttedCopy != null) {
                        ClipBoardBuffer.setClipboardCopy(cuttedCopy, treeTemplate);
                    }
                }
            }
        });
    }

    private boolean canRunForShortcut(IElementWrapper wrapper) {
        Assert.isLegal((boolean)CutElementAction.isShortcut(wrapper));
        if (wrapper.getResolvedElement() == null) {
            return false;
        }
        Entity toCopy = AbstractSelectionAwareAction.resolveSubstitutedCollection(wrapper.getResolvedElement());
        return toCopy != null && toCopy.canCopy() && wrapper.getOriginalElement().canDelete();
    }

    private boolean canRunForRegular(IElementWrapper wrapper) {
        Entity toCut;
        if (wrapper.getResolvedElement() != null && (toCut = AbstractSelectionAwareAction.resolveSubstitutedCollection(wrapper.getResolvedElement())) != null) {
            StringEnumeration stringEnumeration = toCut.participantRoles();
            if (stringEnumeration != null) {
                String role;
                ArrayList<String> list = new ArrayList<String>();
                list.add("Client");
                list.add("Supplier");
                if (stringEnumeration.hasMoreElements()) {
                    role = stringEnumeration.next();
                    ((AbstractCollection)list).remove(role);
                }
                if (stringEnumeration.hasMoreElements()) {
                    role = stringEnumeration.next();
                    ((AbstractCollection)list).remove(role);
                }
                if (list.isEmpty()) {
                    return false;
                }
            }
            return toCut.canCut();
        }
        return false;
    }

    public String getSolvedScr() {
        return "#9473";
    }

    private boolean checkActionFiltersFromXML(DefaultElementWrapper elementWrapper) {
        return CutCopyActionFilterHelper.checkActionFiltersFromXML(elementWrapper);
    }

    static /* synthetic */ Entity access$701(Entity x0) {
        return AbstractSelectionAwareAction.resolveSubstitutedCollection(x0);
    }

    static /* synthetic */ Entity access$801(Entity x0) {
        return AbstractSelectionAwareAction.resolveSubstitutedCollection(x0);
    }
}

