/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import com.tssap.selena.model.ui.actions.common.ClipBoardBuffer;
import com.tssap.selena.model.ui.actions.common.ReferencePropertyRestorer;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;
import com.tssap.selena.model.view.ViewAccess;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;

public class CloneElementAction
extends AbstractSelectionAwareAction {
    private static final Dimension DEFAULT_TRANSLATION = new Dimension(30, 30);

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                ClipBoardBuffer.clear();
                Iterator wrappers = CloneElementAction.super.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    Entity clipboardEntity;
                    DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                    Point clonedTopLeft = CloneElementAction.getClonedTopLeft(wrapper);
                    TreeReferenceTemplate treeReferenceTemplate = ReferencePropertyRestorer.getInstance().createTreeReferenceTemplate(wrapper);
                    Entity element = wrapper.getResolvedElement();
                    if (!(element instanceof Entity) || (clipboardEntity = (element = CloneElementAction.access$201(element)).copy()) == null) continue;
                    Element clone = element.getParent().paste((Element)clipboardEntity);
                    Reference pastedReference = null;
                    if (!CloneElementAction.isEntireDiagramSelected(wrapper)) {
                        pastedReference = ReferencePropertyRestorer.getInstance().restoreReferenceProperties(CloneElementAction.access$401(wrapper), (Entity)clone, treeReferenceTemplate, clonedTopLeft);
                    }
                    if (clone instanceof ReferenceCollection) {
                        CloneElementAction.openDiagram((ReferenceCollection)clone);
                        continue;
                    }
                    CloneElementAction.this.invokeInplaceLater(wrapper, pastedReference);
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.changesIsDisabled()) {
            return false;
        }
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                Entity parent;
                if (element instanceof Entity && (parent = (element = CloneElementAction.access$601((Entity)element)).getParent()) != null) {
                    if (!((Entity)element).canCopy()) {
                        return false;
                    }
                    if (element.hasProperty("$strictClone")) {
                        Entity copiedElement = ((Entity)element).copy();
                        if (copiedElement == null) {
                            return false;
                        }
                        return parent.canPaste((Element)copiedElement);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected void invokeInplaceLater(DefaultElementWrapper wrapper, Reference pastedReference) {
        PropertyMap subProperties;
        ReferenceCollection diagram = AbstractSelectionAwareAction.getTargetCollection(wrapper);
        if (diagram == null || pastedReference == null) {
            return;
        }
        Entity justCreatedEntity = pastedReference.getEntity();
        Property invokeInplace = justCreatedEntity.addProperty("#invoke_inplace", wrapper.getViewID());
        if (invokeInplace != null && (subProperties = invokeInplace.getSubproperties()) != null) {
            subProperties.setPropertyValue("#invoke_inplace_parent_uin", ((Element)pastedReference.getReferenceContainer()).getUniqueName().toString());
            subProperties.setPropertyValue("$ActiveDiagramUIN", diagram.getUniqueName().toString());
        }
    }

    private static void openDiagram(ReferenceCollection diagram) {
        ViewAccess.getViewManager((UniqueName)diagram.getModel().getUniqueName()).createView(diagram, "com.tssap.selena.model.diagram");
    }

    private static Point getClonedTopLeft(IElementWrapper originalWrapper) {
        if (originalWrapper.getOriginalElement() instanceof Reference) {
            String curBoundsAsString = ((Reference)originalWrapper.getOriginalElement()).getPropertyValue("bounds");
            Rectangle curBounds = ReferencePropertyRestorer.getInstance().getBounds(curBoundsAsString);
            if (curBounds != null) {
                return curBounds.getTopLeft().translate(DEFAULT_TRANSLATION);
            }
        }
        return null;
    }

    private static boolean isEntireDiagramSelected(DefaultElementWrapper wrapper) {
        return "com.tssap.selena.gde.diagramMultiPageView".equals(wrapper.getViewID()) && wrapper.getOriginalElement() instanceof ReferenceCollection;
    }

    static /* synthetic */ Entity access$201(Entity x0) {
        return AbstractSelectionAwareAction.resolveSubstitutedCollection(x0);
    }

    static /* synthetic */ ReferenceCollection access$401(IElementWrapper x0) {
        return AbstractSelectionAwareAction.getTargetCollection(x0);
    }

    static /* synthetic */ Entity access$601(Entity x0) {
        return AbstractSelectionAwareAction.resolveSubstitutedCollection(x0);
    }
}

