/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.common.ReferencePropertyRestorer;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;

public class ClipBoardBuffer {
    private static TreeReferenceTemplate myTreeReferenceTemplate;
    private static Entity myClipboardCopy;

    public static void setClipboardCopy(IElementWrapper originalWrapper, Entity justCreatedCopy) {
        ClipBoardBuffer.setClipboardCopy(justCreatedCopy, ClipBoardBuffer.createTreeReferenceTemplate(originalWrapper));
    }

    public static void setClipboardCopy(Entity copy, TreeReferenceTemplate treeReferenceTemplate) {
        if (copy == null) {
            ClipBoardBuffer.clear();
        } else {
            myClipboardCopy = copy;
            myTreeReferenceTemplate = treeReferenceTemplate;
        }
    }

    public static void clear() {
        myTreeReferenceTemplate = null;
        if (myClipboardCopy != null) {
            myClipboardCopy.delete();
            myClipboardCopy = null;
        }
    }

    public static Entity getClipboardCopy() {
        return myClipboardCopy;
    }

    public static TreeReferenceTemplate getTreeReferenceTemplate() {
        return myTreeReferenceTemplate;
    }

    public static boolean isEmpty() {
        return myClipboardCopy == null;
    }

    public static Entity getOriginalEntity() {
        if (myClipboardCopy == null) {
            return null;
        }
        UniqueName clipboardUin = myClipboardCopy.getUniqueName();
        if (clipboardUin instanceof CopyUniqueName) {
            UniqueName originalUin = ((CopyUniqueName)clipboardUin).getOriginalUniqueName();
            if (originalUin == null) {
                return null;
            }
            Entity result = myClipboardCopy.getModel().findEntity(originalUin);
            return result;
        }
        return null;
    }

    public static TreeReferenceTemplate createTreeReferenceTemplate(IElementWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Element original = wrapper.getOriginalElement();
        if (original instanceof Reference) {
            return ReferencePropertyRestorer.getInstance().createTreeReferenceTemplate(wrapper);
        }
        return null;
    }
}

