/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractGenerateClassDiagramAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private ISelection mySelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        final Entity parent = this.computeParentPackage();
        if (parent == null || !parent.canCreateChildReferenceCollection("Class Diagram", null)) {
            return;
        }
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                ViewManager viewManager;
                ReferenceCollection result = parent.createChildReferenceCollection("Class Diagram", null);
                if (result != null) {
                    Iterator shortcuts = AbstractGenerateClassDiagramAction.this.computeShortcuts().iterator();
                    while (shortcuts.hasNext()) {
                        Entity next = (Entity)shortcuts.next();
                        Reference template = result.getModel().createReferenceTemplate();
                        template.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
                        result.addReference(next, template);
                    }
                }
                AbstractGenerateClassDiagramAction.this.workFinished();
                if (result != null && (viewManager = ViewAccess.getViewManager((UniqueName)result.getModel().getUniqueName())) != null) {
                    viewManager.createView(result, "com.tssap.selena.model.diagram");
                }
            }
        }, (String)this.getStatusLineMessage());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = selection;
        boolean enabled = this.isApplicableSelection(selection);
        if (enabled) {
            Entity parent = this.hintParentPackage();
            enabled = parent != null && parent.canCreateChildReferenceCollection("Class Diagram", null);
        }
        action.setEnabled(enabled);
    }

    protected abstract boolean isApplicableSelection(ISelection var1);

    protected abstract Collection computeShortcuts();

    protected abstract Entity hintParentPackage();

    protected abstract Entity computeParentPackage();

    protected abstract void workFinished();

    protected String getStatusLineMessage() {
        return "Generating Class diagram ...";
    }

    protected ISelection getSelection() {
        return this.mySelection;
    }
}

