/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TextActionHandlerExt {
    private DeleteActionHandler textDeleteAction = new DeleteActionHandler();
    private CutActionHandler textCutAction = new CutActionHandler();
    private CopyActionHandler textCopyAction = new CopyActionHandler();
    private PasteActionHandler textPasteAction = new PasteActionHandler();
    private SelectAllActionHandler textSelectAllAction = new SelectAllActionHandler();
    private IAction deleteAction;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction selectAllAction;
    private IPropertyChangeListener deleteActionListener = new PropertyChangeListener((IAction)this.textDeleteAction);
    private IPropertyChangeListener cutActionListener = new PropertyChangeListener((IAction)this.textCutAction);
    private IPropertyChangeListener copyActionListener = new PropertyChangeListener((IAction)this.textCopyAction);
    private IPropertyChangeListener pasteActionListener = new PropertyChangeListener((IAction)this.textPasteAction);
    private IPropertyChangeListener selectAllActionListener = new PropertyChangeListener((IAction)this.textSelectAllAction);
    private Listener textControlListener = new TextControlListener();
    private Text activeTextControl;
    private IViewSite myViewSite = null;
    private String[] myCustomKeyscopes = null;
    private Map myGlobalActionHandlers = new HashMap();
    private static final String[] DEFAULT_SCOPE = new String[]{"com.tssap.selena.textFieldScope"};
    private static final String[] GLOBAL_ACTIONS_2_UNREGISTER = new String[]{"selectAll", "undo", "redo"};
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            TextActionHandlerExt.this.updateActionsEnableState();
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            TextActionHandlerExt.this.updateActionsEnableState();
        }
    };

    public TextActionHandlerExt(IViewSite viewSite) {
        this.myViewSite = viewSite;
        IActionBars actionBar = viewSite.getActionBars();
        actionBar.setGlobalActionHandler("cut", (IAction)this.textCutAction);
        actionBar.setGlobalActionHandler("copy", (IAction)this.textCopyAction);
        actionBar.setGlobalActionHandler("paste", (IAction)this.textPasteAction);
        actionBar.setGlobalActionHandler("selectAll", (IAction)this.textSelectAllAction);
        actionBar.setGlobalActionHandler("delete", (IAction)this.textDeleteAction);
    }

    public IAction getDeleteActionHandler() {
        return this.textDeleteAction;
    }

    public IAction getCutActionHandler() {
        return this.textCutAction;
    }

    public IAction getCopyActionHandler() {
        return this.textCopyAction;
    }

    public IAction getPasteActionHandler() {
        return this.textPasteAction;
    }

    public IAction getSelectAllActionHandler() {
        return this.textSelectAllAction;
    }

    private void setDefaultKeybinding() {
        if (this.myCustomKeyscopes != null) {
            return;
        }
        this.myCustomKeyscopes = this.myViewSite.getKeyBindingService().getScopes();
        this.myViewSite.getKeyBindingService().setScopes(DEFAULT_SCOPE);
        IActionBars actionBars = this.myViewSite.getActionBars();
        int i = 0;
        while (i < GLOBAL_ACTIONS_2_UNREGISTER.length) {
            this.myGlobalActionHandlers.put(GLOBAL_ACTIONS_2_UNREGISTER[i], actionBars.getGlobalActionHandler(GLOBAL_ACTIONS_2_UNREGISTER[i]));
            actionBars.setGlobalActionHandler(GLOBAL_ACTIONS_2_UNREGISTER[i], null);
            ++i;
        }
        actionBars.updateActionBars();
        ((Workbench)WorkbenchPlugin.getDefault().getWorkbench()).updateActiveKeyBindingService();
    }

    private void restoreKeybinding() {
        if (this.myCustomKeyscopes == null) {
            return;
        }
        this.myViewSite.getKeyBindingService().setScopes(this.myCustomKeyscopes);
        IActionBars actionBars = this.myViewSite.getActionBars();
        int i = 0;
        while (i < GLOBAL_ACTIONS_2_UNREGISTER.length) {
            IAction nextAction = (IAction)this.myGlobalActionHandlers.get(GLOBAL_ACTIONS_2_UNREGISTER[i]);
            actionBars.setGlobalActionHandler(GLOBAL_ACTIONS_2_UNREGISTER[i], nextAction);
            ++i;
        }
        actionBars.updateActionBars();
        ((Workbench)WorkbenchPlugin.getDefault().getWorkbench()).updateActiveKeyBindingService();
        this.myGlobalActionHandlers.clear();
        this.myCustomKeyscopes = null;
    }

    public void addText(Text textControl) {
        if (textControl == null) {
            return;
        }
        this.activeTextControl = textControl;
        textControl.addListener(26, this.textControlListener);
        textControl.addListener(27, this.textControlListener);
        textControl.addKeyListener((KeyListener)this.keyAdapter);
        textControl.addMouseListener((MouseListener)this.mouseAdapter);
        this.setDefaultKeybinding();
    }

    public void dispose() {
        this.setCutAction(null);
        this.setCopyAction(null);
        this.setPasteAction(null);
        this.setSelectAllAction(null);
        this.setDeleteAction(null);
    }

    public void removeText(Text textControl) {
        if (textControl == null) {
            return;
        }
        textControl.removeListener(26, this.textControlListener);
        textControl.removeListener(27, this.textControlListener);
        textControl.removeMouseListener((MouseListener)this.mouseAdapter);
        textControl.removeKeyListener((KeyListener)this.keyAdapter);
        this.activeTextControl = null;
        this.updateActionsEnableState();
        this.restoreKeybinding();
    }

    public void setCopyAction(IAction action) {
        if (this.copyAction == action) {
            return;
        }
        if (this.copyAction != null) {
            this.copyAction.removePropertyChangeListener(this.copyActionListener);
        }
        this.copyAction = action;
        if (this.copyAction != null) {
            this.copyAction.addPropertyChangeListener(this.copyActionListener);
        }
        this.textCopyAction.updateEnabledState();
    }

    public void setCutAction(IAction action) {
        if (this.cutAction == action) {
            return;
        }
        if (this.cutAction != null) {
            this.cutAction.removePropertyChangeListener(this.cutActionListener);
        }
        this.cutAction = action;
        if (this.cutAction != null) {
            this.cutAction.addPropertyChangeListener(this.cutActionListener);
        }
        this.textCutAction.updateEnabledState();
    }

    public void setPasteAction(IAction action) {
        if (this.pasteAction == action) {
            return;
        }
        if (this.pasteAction != null) {
            this.pasteAction.removePropertyChangeListener(this.pasteActionListener);
        }
        this.pasteAction = action;
        if (this.pasteAction != null) {
            this.pasteAction.addPropertyChangeListener(this.pasteActionListener);
        }
        this.textPasteAction.updateEnabledState();
    }

    public void setSelectAllAction(IAction action) {
        if (this.selectAllAction == action) {
            return;
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.removePropertyChangeListener(this.selectAllActionListener);
        }
        this.selectAllAction = action;
        if (this.selectAllAction != null) {
            this.selectAllAction.addPropertyChangeListener(this.selectAllActionListener);
        }
        this.textSelectAllAction.updateEnabledState();
    }

    public void setDeleteAction(IAction action) {
        if (this.deleteAction == action) {
            return;
        }
        if (this.deleteAction != null) {
            this.deleteAction.removePropertyChangeListener(this.deleteActionListener);
        }
        this.deleteAction = action;
        if (this.deleteAction != null) {
            this.deleteAction.addPropertyChangeListener(this.deleteActionListener);
        }
        this.textDeleteAction.updateEnabledState();
    }

    private void updateActionsEnableState() {
        this.textCutAction.updateEnabledState();
        this.textCopyAction.updateEnabledState();
        this.textPasteAction.updateEnabledState();
        this.textSelectAllAction.updateEnabledState();
        this.textDeleteAction.updateEnabledState();
    }

    private class SelectAllActionHandler
    extends Action {
        protected SelectAllActionHandler() {
            super("Select All");
            this.setId("TextSelectAllActionHandler");
            this.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                TextActionHandlerExt.this.activeTextControl.selectAll();
                return;
            }
            if (TextActionHandlerExt.this.selectAllAction != null) {
                TextActionHandlerExt.this.selectAllAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                this.setEnabled(true);
                return;
            }
            if (TextActionHandlerExt.this.selectAllAction != null) {
                this.setEnabled(TextActionHandlerExt.this.selectAllAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PasteActionHandler
    extends Action {
        protected PasteActionHandler() {
            super("Paste");
            this.setId("TextPasteActionHandler");
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                TextActionHandlerExt.this.activeTextControl.paste();
                return;
            }
            if (TextActionHandlerExt.this.pasteAction != null) {
                TextActionHandlerExt.this.pasteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                this.setEnabled(true);
                return;
            }
            if (TextActionHandlerExt.this.pasteAction != null) {
                this.setEnabled(TextActionHandlerExt.this.pasteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CopyActionHandler
    extends Action {
        protected CopyActionHandler() {
            super("Copy");
            this.setId("TextCopyActionHandler");
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                TextActionHandlerExt.this.activeTextControl.copy();
                return;
            }
            if (TextActionHandlerExt.this.copyAction != null) {
                TextActionHandlerExt.this.copyAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandlerExt.this.activeTextControl.getSelectionCount() > 0);
                return;
            }
            if (TextActionHandlerExt.this.copyAction != null) {
                this.setEnabled(TextActionHandlerExt.this.copyAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CutActionHandler
    extends Action {
        protected CutActionHandler() {
            super("Cut");
            this.setId("TextCutActionHandler");
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                TextActionHandlerExt.this.activeTextControl.cut();
                return;
            }
            if (TextActionHandlerExt.this.cutAction != null) {
                TextActionHandlerExt.this.cutAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandlerExt.this.activeTextControl.getSelectionCount() > 0);
                return;
            }
            if (TextActionHandlerExt.this.cutAction != null) {
                this.setEnabled(TextActionHandlerExt.this.cutAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class DeleteActionHandler
    extends Action {
        protected DeleteActionHandler() {
            super("Delete");
            this.setId("TextDeleteActionHandler");
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                if (TextActionHandlerExt.this.activeTextControl.getCharCount() == 0) {
                    return;
                }
                Point selection = TextActionHandlerExt.this.activeTextControl.getSelection();
                if (selection.x == selection.y) {
                    int caretPos = TextActionHandlerExt.this.activeTextControl.getCaretPosition();
                    TextActionHandlerExt.this.activeTextControl.setSelection(caretPos, caretPos + 1);
                }
                TextActionHandlerExt.this.activeTextControl.insert("");
                return;
            }
            if (TextActionHandlerExt.this.deleteAction != null) {
                TextActionHandlerExt.this.deleteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandlerExt.this.activeTextControl != null && !TextActionHandlerExt.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandlerExt.this.activeTextControl.getSelectionCount() > 0 || TextActionHandlerExt.this.activeTextControl.getCaretPosition() < TextActionHandlerExt.this.activeTextControl.getCharCount());
                return;
            }
            if (TextActionHandlerExt.this.deleteAction != null) {
                this.setEnabled(TextActionHandlerExt.this.deleteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private IAction actionHandler;

        protected PropertyChangeListener(IAction actionHandler) {
            this.actionHandler = actionHandler;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (TextActionHandlerExt.this.activeTextControl != null) {
                return;
            }
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.actionHandler.setEnabled(bool.booleanValue());
            }
        }
    }

    private class TextControlListener
    implements Listener {
        private TextControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    TextActionHandlerExt.this.activeTextControl = (Text)event.widget;
                    TextActionHandlerExt.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    TextActionHandlerExt.this.activeTextControl = null;
                    TextActionHandlerExt.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }
}

