/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.model.ui.actions.DeleteElementAction;
import com.tssap.selena.model.ui.actions.ITextActionsViewPart;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import com.tssap.selena.model.ui.actions.common.CopyElementAction;
import com.tssap.selena.model.ui.actions.common.CutElementAction;
import com.tssap.selena.model.ui.actions.common.PasteElementAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class RetargetActionGroup
extends ActionGroup {
    private IViewPart myViewPart;
    private Map myId2Delegate;
    private static final String[] TEXT_ACTION_IDS = new String[]{"delete", "copy", "paste", "cut", "selectAll"};
    private TextActionHandlerExt myTextActionHandler;

    public RetargetActionGroup(ITextActionsViewPart viewPart) {
        this.myViewPart = viewPart;
        this.myId2Delegate = new HashMap();
        this.myTextActionHandler = new TextActionHandlerExt(this.myViewPart.getViewSite());
        this.addPredefinedActions();
    }

    public TextActionHandlerExt getTextActionHandler() {
        return this.myTextActionHandler;
    }

    protected void addPredefinedActions() {
        this.addActionDelegate("delete", new DeleteElementAction());
        this.addActionDelegate("copy", new CopyElementAction());
        this.addActionDelegate("cut", new CutElementAction());
        this.addActionDelegate("paste", new PasteElementAction());
    }

    public void addActionDelegate(String retargetID, IObjectActionDelegate delegate) {
        if (Arrays.asList(TEXT_ACTION_IDS).contains(retargetID)) {
            this.addToTextHandler(retargetID, delegate);
        } else {
            this.addToOwnMap(retargetID, delegate);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        Iterator entries = this.myId2Delegate.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            String nextRetargetId = (String)nextEntry.getKey();
            SelectionDispatchAction nextAction = (SelectionDispatchAction)((Object)nextEntry.getValue());
            actionBars.setGlobalActionHandler(nextRetargetId, (IAction)nextAction);
        }
    }

    public void dispose() {
        Iterator entries = this.myId2Delegate.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            SelectionDispatchAction nextAction = (SelectionDispatchAction)((Object)nextEntry.getValue());
            this.removeSelectionListener(nextAction);
            entries.remove();
        }
        this.myId2Delegate = null;
        this.myViewPart = null;
        this.myTextActionHandler.dispose();
        this.myTextActionHandler = null;
        super.dispose();
    }

    private void registerSelectionListener(ISelectionChangedListener listener) {
        this.myViewPart.getSite().getSelectionProvider().addSelectionChangedListener(listener);
    }

    private void removeSelectionListener(ISelectionChangedListener listener) {
        this.myViewPart.getSite().getSelectionProvider().removeSelectionChangedListener(listener);
    }

    private void addToTextHandler(String retargetID, IObjectActionDelegate delegate) {
        Assert.isLegal((boolean)Arrays.asList(TEXT_ACTION_IDS).contains(retargetID));
        SelectionDispatchAction newAction = new SelectionDispatchAction(this.myViewPart, delegate);
        this.registerSelectionListener(newAction);
        if ("copy".equals(retargetID)) {
            this.myTextActionHandler.setCopyAction((IAction)newAction);
            return;
        }
        if ("cut".equals(retargetID)) {
            this.myTextActionHandler.setCutAction((IAction)newAction);
            return;
        }
        if ("delete".equals(retargetID)) {
            this.myTextActionHandler.setDeleteAction((IAction)newAction);
            return;
        }
        if ("paste".equals(retargetID)) {
            this.myTextActionHandler.setPasteAction((IAction)newAction);
            return;
        }
        if ("selectAll".equals(retargetID)) {
            this.myTextActionHandler.setSelectAllAction((IAction)newAction);
            return;
        }
    }

    private void addToOwnMap(String retargetID, IObjectActionDelegate delegate) {
        SelectionDispatchAction oldAction = (SelectionDispatchAction)((Object)this.myId2Delegate.get(retargetID));
        if (oldAction != null) {
            this.removeSelectionListener(oldAction);
        }
        SelectionDispatchAction newAction = new SelectionDispatchAction(this.myViewPart, delegate);
        this.registerSelectionListener(newAction);
        this.myId2Delegate.put(retargetID, newAction);
    }

    private static class SelectionDispatchAction
    extends Action
    implements ISelectionChangedListener {
        private IWorkbenchSite fSite;
        private IObjectActionDelegate myDelegate;

        protected SelectionDispatchAction(IViewPart viewPart, IObjectActionDelegate delegate) {
            Assert.isNotNull((Object)viewPart);
            Assert.isNotNull((Object)delegate);
            this.fSite = viewPart.getViewSite();
            this.myDelegate = delegate;
            this.initDelegate(viewPart);
        }

        private void initDelegate(IViewPart viewPart) {
            this.myDelegate.setActivePart((IAction)this, (IWorkbenchPart)viewPart);
        }

        public IWorkbenchSite getSite() {
            return this.fSite;
        }

        public ISelection getSelection() {
            return this.getSelectionProvider().getSelection();
        }

        public Shell getShell() {
            return this.fSite.getShell();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fSite.getSelectionProvider();
        }

        public final boolean isEnabled() {
            this.updateFromDelegate(this.getSelection());
            return super.isEnabled();
        }

        private void updateFromDelegate(ISelection selection) {
            if (selection != null) {
                this.myDelegate.selectionChanged((IAction)this, this.getSelection());
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.isEnabled()) {
                this.myDelegate.run((IAction)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateFromDelegate(event.getSelection());
        }
    }
}

