/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Participant;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.ui.actions.Messages;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RenameActionHelper {
    public static UnaryElementCondition getElementCondition() {
        return new UnaryElementCondition(){

            public boolean check(Element element) {
                Entity entity;
                if (element instanceof ReferenceCollection && element.hasProperty("automaticallySynchronized")) {
                    element = ((ReferenceCollection)element).getParent();
                }
                if (element instanceof Model) {
                    return false;
                }
                if (element.isDeleted()) {
                    return false;
                }
                if (element.hasProperty("$readOnly")) {
                    return false;
                }
                if (!element.hasProperty("$name")) {
                    return false;
                }
                if (RenameActionHelper.isNamePropertyChangeForbidden(element)) {
                    return false;
                }
                if (element instanceof Reference && (entity = ((Reference)element).getEntity()) != null && entity.hasProperty("$readOnly")) {
                    return false;
                }
                if (RenameActionHelper.isPatternNode(element)) {
                    return false;
                }
                return !(element instanceof Entity) || !RenameActionHelper.isLink((Entity)element);
            }
        };
    }

    public static void rename(final Element element) {
        if (!RenameActionHelper.getElementCondition().check(element)) {
            return;
        }
        final String name = element.getPropertyValue("$name");
        String title = Messages.getString("RenameActionHelper.Rename");
        String message = Messages.getString("RenameActionHelper.New_Name");
        InputDialog dialog = new InputDialog(RenameActionHelper.getShell(), title, message, name, new IInputValidator(){

            public String isValid(String newText) {
                return name.equals(newText) || element.canSetPropertyValue("$name", newText) ? null : Messages.getString("RenameActionHelper.Invalid_name_enter_valid");
            }
        });
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            return;
        }
        String newName = dialog.getValue();
        RenameActionHelper.rename(element, newName);
    }

    public static void rename(final Element element, final String newName) {
        if (!RenameActionHelper.getElementCondition().check(element)) {
            return;
        }
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                String oldName = element.getPropertyValue("$name");
                if (oldName != null && oldName.equals(newName)) {
                    return;
                }
                if (element.canSetPropertyValue("$name", newName)) {
                    element.setPropertyValue("$name", newName);
                } else {
                    String[] buttons = new String[]{Messages.getString("RenameActionHelper.OK")};
                    MessageDialog dlg = new MessageDialog(null, Messages.getString("RenameActionHelper.Invalid_name"), null, Messages.getString("RenameActionHelper.Invalid_name_enter_valid"), 4, buttons, 0);
                    dlg.open();
                }
            }
        });
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static boolean isLink(Entity entity) {
        Participant[] candidates = new Participant[2];
        ParticipantEnumeration participants = entity.allParticipants();
        while (participants.hasMoreElements()) {
            Participant participant = (Participant)participants.nextElement();
            if ("Client".equals(participant.getRole())) {
                if (candidates[0] != null) {
                    return false;
                }
                candidates[0] = participant;
                continue;
            }
            if ("Supplier".equals(participant.getRole())) {
                if (candidates[1] != null) {
                    return false;
                }
                candidates[1] = participant;
                continue;
            }
            return false;
        }
        return candidates[0] != null && candidates[1] != null;
    }

    private static boolean isPatternNode(Element element) {
        Element patternNodeCandidate = element;
        if (element instanceof Reference) {
            patternNodeCandidate = ((Reference)element).getEntity();
        }
        return patternNodeCandidate.hasPropertyValue("$metaclass", "Pattern");
    }

    private static boolean isNamePropertyChangeForbidden(Element element) {
        Element renameTarget = element;
        if (element instanceof Reference) {
            renameTarget = ((Reference)element).getEntity();
        }
        return renameTarget.hasProperty("$ro-name");
    }
}

