/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ModelUIOptionsSupport;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.ConfirmDeletionDialog;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteFromViewAction
extends AbstractSelectionAwareAction {
    public void run(IAction action) {
        boolean isMultipleSelection = this.getSelection().size() > 1;
        this.runInBatchMode(isMultipleSelection, false);
    }

    protected int runInBatchMode(final boolean isMultipleSelection, final boolean alreadyYesToAll) {
        final int[] dialogReturnCode = new int[]{0};
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                boolean skipConfirmation = DeleteFromViewAction.isSkipConfirmationAllowed() || alreadyYesToAll;
                Iterator wrappers = DeleteFromViewAction.this.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                    Element originalElement = wrapper.getOriginalElement();
                    boolean bl = skipConfirmation = skipConfirmation || DeleteFromViewAction.isSkipConfirmationAllowed();
                    if (!skipConfirmation) {
                        ConfirmDeletionDialog dlg = new ConfirmDeletionDialog(DeleteFromViewAction.this.getShell(), originalElement, DeleteFromViewAction.this.getConfirmationOptions(isMultipleSelection));
                        dlg.setBlockOnOpen(true);
                        dlg.open();
                        dialogReturnCode[0] = dlg.getReturnCode();
                        if (dlg.getReturnCode() == 1) break;
                        boolean bl2 = skipConfirmation = skipConfirmation || dlg.getReturnCode() == 4;
                    }
                    if (originalElement == null || originalElement.isDeleted()) continue;
                    originalElement.delete();
                }
            }
        });
        return dialogReturnCode[0];
    }

    protected boolean customIsChecked() {
        return false;
    }

    private static boolean isSkipConfirmationAllowed() {
        return ModelUIOptionsSupport.getOptionsSupport().getBooleanOption("model.ui.option.skip_delete_confirmation");
    }

    protected boolean customIsEnabled() {
        return this.checkConditionForAllSelected(new UnaryWrapperCondition(){

            public boolean check(DefaultElementWrapper wrapper) {
                Element originalElement = wrapper.getOriginalElement();
                return DeleteFromViewAction.isShortcut(originalElement) && originalElement.canDelete();
            }
        });
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static boolean isShortcut(Element element) {
        return element instanceof Reference && element.hasProperty("$shortcutReference");
    }

    private ConfirmDeletionDialog.Options getConfirmationOptions(final boolean yesToAllButtonNeeded) {
        return new ConfirmDeletionDialog.Options(){

            public boolean deletionTypeKnown() {
                return true;
            }

            public boolean deleteFromModel() {
                return false;
            }

            public boolean allButtonShouldPresent() {
                return yesToAllButtonNeeded;
            }
        };
    }
}

