/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.internal.model.ui.DeleteHandlerRegistry;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ModelUIOptionsSupport;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.ConfirmDeletionDialog;
import com.tssap.selena.model.ui.actions.Messages;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteFromModelAction
extends AbstractSelectionAwareAction {
    private static final String PACKAGE_CONFIRMATION_MESSAGE_HEAD = Messages.getString("DeleteFromModelAction.PackageConfirmation_Head");
    private static final String PACKAGE_CONFIRMATION_MESSAGE_TAIL = Messages.getString("DeleteFromModelAction.PackageConfirmation_Tail");
    private static final String PACKAGE_CONFIRMATION_TITLE = Messages.getString("DeleteFromModelAction.Confirmation");
    private static final String[] PACKAGE_CONFIRMATION_BUTTONS = new String[]{Messages.getString("DeleteFromModelAction.Yes"), Messages.getString("DeleteFromModelAction.No")};

    public void run(IAction action) {
        boolean isMultipleSelection = this.getSelection().size() > 1;
        this.runInBatchMode(isMultipleSelection, false);
    }

    protected int runInBatchMode(final boolean isMultipleSelection, final boolean alreadyYesToAll) {
        final int[] dialogReturnCode = new int[]{0};
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                boolean skipConfirmation = DeleteFromModelAction.isSkipConfirmationAllowed() || alreadyYesToAll;
                Iterator wrappers = DeleteFromModelAction.this.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    Entity resolvedElement;
                    DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                    Element originalElement = wrapper.getOriginalElement();
                    boolean bl = skipConfirmation = skipConfirmation || DeleteFromModelAction.isSkipConfirmationAllowed();
                    if (!skipConfirmation) {
                        ConfirmDeletionDialog dlg = new ConfirmDeletionDialog(DeleteFromModelAction.this.getShell(), originalElement, DeleteFromModelAction.this.getConfirmationOptions(isMultipleSelection));
                        dlg.setBlockOnOpen(true);
                        dlg.open();
                        dialogReturnCode[0] = dlg.getReturnCode();
                        if (dlg.getReturnCode() == 1) break;
                        boolean bl2 = skipConfirmation = skipConfirmation || dlg.getReturnCode() == 4;
                    }
                    if ((resolvedElement = wrapper.getResolvedElement()) instanceof ReferenceCollection && resolvedElement.hasProperty("$defaultDiagram")) {
                        resolvedElement = resolvedElement.getParent();
                    }
                    if (resolvedElement == null || !DeleteHandlerRegistry.canDelete((Element)resolvedElement)) continue;
                    resolvedElement.delete();
                }
            }
        });
        return dialogReturnCode[0];
    }

    private Dialog createPackageConfrimationDialog(Element element) {
        return new MessageDialog(null, PACKAGE_CONFIRMATION_TITLE, JFaceResources.getImageRegistry().get("dialog_warning_image"), PACKAGE_CONFIRMATION_MESSAGE_HEAD + element.getPropertyValue("$metaclass") + " " + element.getPropertyValue("$name") + PACKAGE_CONFIRMATION_MESSAGE_TAIL, 4, new String[]{Messages.getString("DeleteFromModelAction.Yes"), Messages.getString("DeleteFromModelAction.No")}, 1);
    }

    protected boolean customIsChecked() {
        return false;
    }

    private static boolean isSkipConfirmationAllowed() {
        return ModelUIOptionsSupport.getOptionsSupport().getBooleanOption("model.ui.option.skip_delete_confirmation");
    }

    protected boolean customIsEnabled() {
        if (this.changesIsDisabled()) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryWrapperCondition(){

            public boolean check(DefaultElementWrapper wrapper) {
                Element originalElement = wrapper.getOriginalElement();
                Entity resolvedElement = wrapper.getResolvedElement();
                if (resolvedElement instanceof ReferenceCollection && resolvedElement.hasProperty("$defaultDiagram") && (resolvedElement = resolvedElement.getParent()) instanceof Model) {
                    return false;
                }
                if (resolvedElement != null) {
                    return resolvedElement.canDelete();
                }
                return false;
            }
        });
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private ConfirmDeletionDialog.Options getConfirmationOptions(final boolean yesToAllNeeded) {
        return new ConfirmDeletionDialog.Options(){

            public boolean deletionTypeKnown() {
                return true;
            }

            public boolean deleteFromModel() {
                return true;
            }

            public boolean allButtonShouldPresent() {
                return yesToAllNeeded;
            }
        };
    }
}

