/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.internal.model.ui.DeleteHandlerRegistry;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ModelUIOptionsSupport;
import com.tssap.selena.model.ui.actions.ConfirmDeletionDialog;
import com.tssap.selena.model.ui.actions.DeleteFromModelAction;
import com.tssap.selena.model.ui.actions.DeleteFromViewAction;
import com.tssap.selena.model.ui.actions.SelectionUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteElementAction
implements IObjectActionDelegate {
    private DeleteFromViewAction myDeleteFromViewAction = new DeleteFromViewAction();
    private DeleteFromModelAction myDeleteFromModelAction = new DeleteFromModelAction();
    private StructuredSelection mySelection;
    private boolean myMultipleSelection;
    private static IAction myProbeAction = new Action(){};
    private static String DELETE_FROM_MODEL = "model.ui.option.delete_from_model";
    private static String DELETE_FROM_VIEW = "model.ui.option.delete_from_view";

    public void selectionChanged(IAction action, ISelection selection) {
        LinkedList toDeleteFromView = new LinkedList();
        LinkedList toDeleteFromModel = new LinkedList();
        LinkedList toUserSetMode = new LinkedList();
        this.separateSelection(selection, toUserSetMode, toDeleteFromModel, toDeleteFromView);
        this.myDeleteFromModelAction.selectionChanged(action, (ISelection)new StructuredSelection(toDeleteFromModel));
        this.myDeleteFromViewAction.selectionChanged(action, (ISelection)new StructuredSelection(toDeleteFromView));
        this.myMultipleSelection = toDeleteFromModel.size() + toDeleteFromView.size() + toUserSetMode.size() > 1;
        boolean atLeastOneDeletable = toDeleteFromModel.size() + toDeleteFromView.size() + toUserSetMode.size() > 0;
        this.mySelection = new StructuredSelection(toUserSetMode);
        action.setEnabled(atLeastOneDeletable && this.isWrapperSelection(selection) && !this.changesIsDisabled(selection));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myDeleteFromModelAction.setActivePart(action, targetPart);
        this.myDeleteFromViewAction.setActivePart(action, targetPart);
    }

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                int lastDialogResult = DeleteElementAction.this.myDeleteFromModelAction.runInBatchMode(DeleteElementAction.this.myMultipleSelection, false);
                if (lastDialogResult == 1) {
                    return;
                }
                lastDialogResult = DeleteElementAction.this.myDeleteFromViewAction.runInBatchMode(DeleteElementAction.this.myMultipleSelection, lastDialogResult == 4);
                if (lastDialogResult == 1) {
                    return;
                }
                DeleteElementAction.this.runForUnknownMode(DeleteElementAction.this.mySelection);
            }
        });
    }

    protected boolean isWrapperSelection(ISelection selection) {
        return !SelectionUtil.selection2DefaultWrapperList(selection).isEmpty();
    }

    protected boolean changesIsDisabled(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return true;
        }
        if (selection instanceof IStructuredSelection) {
            List wrapperSelection = SelectionUtil.selection2DefaultWrapperList(selection);
            Iterator wrappers = wrapperSelection.iterator();
            while (wrappers.hasNext()) {
                DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                Element originalElement = wrapper.getOriginalElement();
                if (!originalElement.hasProperty("$readOnly")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isDeletableFromModel(DefaultElementWrapper wrapper) {
        myProbeAction.setEnabled(true);
        this.myDeleteFromModelAction.selectionChanged(myProbeAction, (ISelection)new StructuredSelection((Object)wrapper));
        return myProbeAction.isEnabled();
    }

    private boolean isDeletableFromView(DefaultElementWrapper wrapper) {
        myProbeAction.setEnabled(true);
        this.myDeleteFromViewAction.selectionChanged(myProbeAction, (ISelection)new StructuredSelection((Object)wrapper));
        return myProbeAction.isEnabled();
    }

    private void separateSelection(ISelection source, List unknownMode, List deleteFromModel, List deleteFromView) {
        if (source instanceof IStructuredSelection) {
            Iterator selected = ((IStructuredSelection)source).iterator();
            while (selected.hasNext()) {
                Object next = selected.next();
                if (!(next instanceof DefaultElementWrapper)) continue;
                DefaultElementWrapper curWrapper = (DefaultElementWrapper)next;
                if (DeleteElementAction.checkOption(DELETE_FROM_MODEL)) {
                    if (this.isDeletableFromModel(curWrapper)) {
                        deleteFromModel.add(curWrapper);
                        continue;
                    }
                    if (!this.isDeletableFromView(curWrapper)) continue;
                    deleteFromView.add(curWrapper);
                    continue;
                }
                if (DeleteElementAction.checkOption(DELETE_FROM_VIEW)) {
                    if (this.isDeletableFromView(curWrapper)) {
                        deleteFromView.add(curWrapper);
                        continue;
                    }
                    if (!this.isDeletableFromModel(curWrapper)) continue;
                    deleteFromModel.add(curWrapper);
                    continue;
                }
                boolean fromView = this.isDeletableFromView(curWrapper);
                boolean fromModel = this.isDeletableFromModel(curWrapper);
                if (fromView && fromModel) {
                    unknownMode.add(curWrapper);
                    continue;
                }
                if (fromView) {
                    deleteFromView.add(curWrapper);
                }
                if (!fromModel) continue;
                deleteFromModel.add(curWrapper);
            }
        }
    }

    private void runForUnknownMode(final StructuredSelection selection) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                boolean skipConfirmation = DeleteElementAction.isSkipConfirmationAllowed();
                Iterator wrappers = selection.iterator();
                while (wrappers.hasNext()) {
                    boolean deleteFromModel;
                    DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                    Element originalElement = wrapper.getOriginalElement();
                    boolean bl = skipConfirmation = skipConfirmation || DeleteElementAction.isSkipConfirmationAllowed();
                    if (!skipConfirmation) {
                        ConfirmDeletionDialog dlg = new ConfirmDeletionDialog(DeleteElementAction.this.getShell(), originalElement, DeleteElementAction.this.getConfirmationOptions(selection.size() > 1));
                        dlg.setBlockOnOpen(true);
                        dlg.open();
                        if (dlg.getReturnCode() == 1) continue;
                        boolean bl2 = skipConfirmation = skipConfirmation || dlg.getReturnCode() == 4;
                    }
                    if (deleteFromModel = DeleteElementAction.checkOption("model.ui.option.recent_delete_from_model")) {
                        Entity resolvedElement = wrapper.getResolvedElement();
                        if (resolvedElement instanceof ReferenceCollection && resolvedElement.hasProperty("$defaultDiagram")) {
                            resolvedElement = resolvedElement.getParent();
                        }
                        if (!DeleteHandlerRegistry.canDelete((Element)resolvedElement)) continue;
                        resolvedElement.delete();
                        continue;
                    }
                    originalElement.delete();
                }
            }
        });
    }

    private static boolean isSkipConfirmationAllowed() {
        return DeleteElementAction.checkOption("model.ui.option.skip_delete_confirmation");
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static boolean checkOption(String optionKey) {
        return ModelUIOptionsSupport.getOptionsSupport().getBooleanOption(optionKey);
    }

    private ConfirmDeletionDialog.Options getConfirmationOptions(final boolean allButtonsShouldPresent) {
        return new ConfirmDeletionDialog.Options(){

            public boolean deletionTypeKnown() {
                return false;
            }

            public boolean deleteFromModel() {
                return false;
            }

            public boolean allButtonShouldPresent() {
                return allButtonsShouldPresent;
            }
        };
    }
}

