/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.ui.ModelUIOptionsSupport;
import com.tssap.selena.model.ui.actions.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfirmDeletionDialog
extends Dialog {
    private Options myOptions;
    private Element myElementToDelete;
    private Button myAlwaysDeleteButton;
    private Button myDeleteFromModelButton;

    public ConfirmDeletionDialog(Shell parentShell, Element elementToDelete, Options options) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 8);
        this.myElementToDelete = elementToDelete;
        this.myOptions = options;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getShellText());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.myOptions.allButtonShouldPresent()) {
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (4 == buttonId) {
            this.setReturnCode(4);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void addWarningIcon(Composite composite) {
        Label iconLabel = new Label(composite, 16384);
        GridData gd = new GridData();
        iconLabel.setLayoutData((Object)gd);
        iconLabel.setFont(composite.getFont());
        Image i = JFaceResources.getImageRegistry().get("dialog_warning_image");
        if (i != null) {
            iconLabel.setImage(i);
        }
    }

    private void addMessageBoard(Composite composite) {
        Composite board = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        board.setLayout((Layout)layout);
        Label label = new Label(board, 0x1000000);
        label.setText(this.getLabelText());
        if (!this.myOptions.deletionTypeKnown()) {
            this.addDeleteFromModel(board);
        }
        this.addAlwaysDeleteButton(board);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addWarningIcon(composite);
        this.addMessageBoard(composite);
        return composite;
    }

    private boolean isDeleteFromModelSelectable() {
        return !ModelUIOptionsSupport.getOptionsSupport().getBooleanOption("model.ui.option.delete_from_model") && !ModelUIOptionsSupport.getOptionsSupport().getBooleanOption("model.ui.option.delete_from_view") && this.myElementToDelete instanceof Reference && this.myElementToDelete.hasProperty("$shortcutReference");
    }

    private void addAlwaysDeleteButton(Composite parent) {
        this.myAlwaysDeleteButton = new Button(parent, 32);
        this.myAlwaysDeleteButton.setText(this.getAlwaysDeleteButtonText());
        this.myAlwaysDeleteButton.addSelectionListener((SelectionListener)new OptionsSetListener("model.ui.option.skip_delete_confirmation", false));
    }

    private void addDeleteFromModel(Composite parent) {
        if (this.isDeleteFromModelSelectable()) {
            this.myDeleteFromModelButton = new Button(parent, 32);
            this.myDeleteFromModelButton.setText(this.getDeleteFromModelButtonText());
            this.myDeleteFromModelButton.setSelection(ModelUIOptionsSupport.getOptionsSupport().getBooleanOption("model.ui.option.recent_delete_from_model"));
            this.myDeleteFromModelButton.addSelectionListener((SelectionListener)new OptionsSetListener("model.ui.option.recent_delete_from_model", false));
        }
    }

    private String getLabelText() {
        String name = this.myElementToDelete.getPropertyValue("$name");
        return Messages.getString("ConfirmDeletionDialog.Delete__1") + name + "?";
    }

    private String getAlwaysDeleteButtonText() {
        return Messages.getString("ConfirmDeletionDialog.Skip_this_dialog,_always_delete_3");
    }

    private String getDeleteFromModelButtonText() {
        return Messages.getString("ConfirmDeletionDialog.Delete_from_model_4");
    }

    private String getShellText() {
        return Messages.getString("ConfirmDeletionDialog.Confirmation_5");
    }

    private static class OptionsSetListener
    implements SelectionListener {
        private String myOptionsKey;
        private boolean myInvertFlag;

        public OptionsSetListener(String optionsKey, boolean invertFlag) {
            this.myOptionsKey = optionsKey;
            this.myInvertFlag = invertFlag;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                boolean buttonSelected = ((Button)e.widget).getSelection();
                ModelUIOptionsSupport.getOptionsSupport().setBooleanOption(this.myOptionsKey, this.getValue(buttonSelected));
            }
        }

        private boolean getValue(boolean widgetSelected) {
            return this.myInvertFlag ? !widgetSelected : widgetSelected;
        }
    }

    public static interface Options {
        public boolean deletionTypeKnown();

        public boolean deleteFromModel();

        public boolean allButtonShouldPresent();
    }
}

