/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.SelectionUtil;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractSelectionAwareAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final ImageDescriptor ourChecked = AbstractSelectionAwareAction.createIconImageDescriptor("icons/check.gif");
    private IStructuredSelection mySelection;
    private boolean myMainMenuFlag;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.myMainMenuFlag = true;
    }

    protected abstract boolean customIsEnabled();

    protected abstract boolean customIsChecked();

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        if (this.myMainMenuFlag && !this.isAppropriateSelection()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.customIsEnabled());
        }
        boolean isChecked = this.customIsChecked();
        if (isChecked) {
            action.setImageDescriptor(ourChecked);
        } else if (action.getImageDescriptor() == ourChecked) {
            action.setImageDescriptor(null);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected boolean isAppropriateSelection() {
        boolean isIElementWrapper = true;
        if (this.mySelection != null) {
            isIElementWrapper = this.mySelection.getFirstElement() instanceof IElementWrapper;
        }
        return isIElementWrapper;
    }

    protected boolean changesIsDisabled() {
        if (this.getSelection() == null || this.getSelection().size() == 0) {
            return true;
        }
        boolean allElementsWritable = this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                if (element instanceof ReferenceCollection) {
                    element = element.getParent();
                }
                return !element.hasProperty("$readOnly");
            }
        });
        return !allElementsWritable;
    }

    protected boolean changesIsDisabledForCreation() {
        if (this.getSelection() == null || this.getSelection().size() == 0) {
            return true;
        }
        boolean allElementsWritable = this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                if (element instanceof ReferenceCollection) {
                    element = element.getParent();
                }
                if (element.hasPropertyValue("$metaclass", "Package")) {
                    return true;
                }
                return !element.hasProperty("$readOnly");
            }
        });
        return !allElementsWritable;
    }

    protected IStructuredSelection getSelection() {
        return this.mySelection;
    }

    protected final Iterator selectedModelElementsIterator() {
        return SelectionUtil.selection2ModelElementList((ISelection)this.getSelection()).iterator();
    }

    protected final Iterator selectedWrappersIterator() {
        return SelectionUtil.selection2DefaultWrapperList((ISelection)this.getSelection()).iterator();
    }

    protected final boolean checkConditionForAllSelected(UnaryWrapperCondition condition) {
        Iterator wrappers = this.selectedWrappersIterator();
        while (wrappers.hasNext()) {
            DefaultElementWrapper curWrapper = (DefaultElementWrapper)wrappers.next();
            if (condition.check(curWrapper)) continue;
            return false;
        }
        return true;
    }

    protected final boolean checkConditionForAllSelected(UnaryElementCondition condition) {
        UnaryWrapperCondition.Adapter wrapperCondition = new UnaryWrapperCondition.Adapter(condition);
        return this.checkConditionForAllSelected(wrapperCondition);
    }

    protected void addReferenceToNotSynchronizedCollection(DefaultElementWrapper selectedWrapper, Element clonedElement) {
        ReferenceCollection collection = AbstractSelectionAwareAction.getTargetCollection(selectedWrapper);
        if (collection != null && AbstractSelectionAwareAction.shouldAddShortcut(collection, (Entity)clonedElement)) {
            collection.addReference((Entity)clonedElement, this.getShortcutTemplate(collection.getModel()));
        }
    }

    protected static ReferenceCollection getTargetCollection(IElementWrapper selectedWrapper) {
        ReferenceCollection collection = null;
        if (selectedWrapper.getOriginalElement() instanceof Reference) {
            Reference reference = (Reference)selectedWrapper.getOriginalElement();
            collection = reference.getEntity() instanceof ReferenceCollection ? (ReferenceCollection)reference.getEntity() : (ReferenceCollection)reference.getParent();
        } else if (selectedWrapper.getOriginalElement() instanceof ReferenceCollection) {
            collection = (ReferenceCollection)selectedWrapper.getOriginalElement();
        }
        return collection;
    }

    protected static ReferenceContainer getTargetReferenceContainer(IElementWrapper selectedWrapper) {
        Object result = null;
        if (selectedWrapper.getOriginalElement() instanceof ReferenceContainer) {
            return (ReferenceContainer)selectedWrapper.getOriginalElement();
        }
        String defDiagramUinStr = selectedWrapper.getResolvedElement().getPropertyValue("DiagramUIN");
        if (defDiagramUinStr != null) {
            return selectedWrapper.getResolvedElement().getModel().findReferenceCollection(ModelAccess.createUniqueName((String)defDiagramUinStr));
        }
        return null;
    }

    public static boolean shouldAddShortcut(ReferenceCollection collection, Entity element) {
        boolean equalsParents;
        if (collection == null || element == null) {
            return false;
        }
        if (collection.getParent() == null) {
            System.err.println("Attention: parent == null for collection: " + collection);
            return false;
        }
        if (element.getParent() == null) {
            System.err.println("Attention: parent == null for entity: " + element);
            return false;
        }
        boolean synchronizedRC = collection.hasProperty("automaticallySynchronized");
        if (element.hasProperty("$defaultDiagram")) {
            Entity substitutedParent = element.getParent();
            equalsParents = collection.getParent().getUniqueName().equals(substitutedParent.getParent().getUniqueName());
        } else {
            equalsParents = collection.getParent().getUniqueName().equals(element.getParent().getUniqueName());
        }
        if (!synchronizedRC) {
            return equalsParents;
        }
        if ("Package Diagram".equals(collection.getPropertyValue("$metaclass")) && element.hasPropertyValue("$design:entity_type", "node")) {
            return !element.getParent().hasProperty("$design:entity_type");
        }
        return !AbstractSelectionAwareAction.isReferenced((ReferenceContainer)collection, element);
    }

    private static boolean isReferenced(ReferenceContainer container, Entity entity) {
        String substitutedDiagramUinStr = entity.getPropertyValue("DiagramUIN");
        ReferenceEnumeration topReferences = container.references();
        while (topReferences.hasMoreElements()) {
            Reference cur = topReferences.next();
            Entity curEntity = cur.getEntity();
            if (entity.getUniqueName().equals(curEntity.getUniqueName())) {
                return true;
            }
            if (substitutedDiagramUinStr != null && curEntity != null && substitutedDiagramUinStr.equals(curEntity.getUniqueName().toString())) {
                return true;
            }
            if (!AbstractSelectionAwareAction.isReferenced((ReferenceContainer)cur, entity)) continue;
            return true;
        }
        return false;
    }

    private Reference getShortcutTemplate(Model model) {
        Reference result = model.createReferenceTemplate();
        result.setPropertyValue("$shortcutReference", "true");
        return result;
    }

    private static ImageDescriptor createIconImageDescriptor(String iconRelativePath) {
        URL url = null;
        try {
            url = new URL(ModelUIPlugin.getDefault().getDescriptor().getInstallURL(), iconRelativePath);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ImageDescriptor.createFromURL(url);
    }

    protected static Entity resolveSubstitutedCollection(Entity resolvedReference) {
        if (resolvedReference instanceof ReferenceCollection && resolvedReference.hasProperty("automaticallySynchronized")) {
            return resolvedReference.getParent();
        }
        return resolvedReference;
    }

    protected final void setInplaceProperty(Entity justCreatedEntity, IElementWrapper parentWrapper) {
        PropertyMap subProperties;
        if (justCreatedEntity == null || parentWrapper == null) {
            return;
        }
        Property invokeInplace = justCreatedEntity.addProperty("#invoke_inplace", parentWrapper.getViewID());
        if (invokeInplace != null && (subProperties = invokeInplace.getSubproperties()) != null) {
            subProperties.setPropertyValue("#invoke_inplace_parent_uin", parentWrapper.getOriginalElement().getUniqueName().toString());
            subProperties.setPropertyValue("$ActiveDiagramUIN", parentWrapper.getUserProperty("$ActiveDiagramUIN"));
        }
    }
}

