/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui;

import com.tssap.selena.internal.model.ui.DefaultPropertyDescriptor;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.ui.AutoConfigurablePropertySet;
import com.tssap.selena.model.ui.property.IPropertySet;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class WrapperElementPropertySource
implements IPropertySource {
    private HashMap myId2Properties;
    private Element myElement;
    private Class myObjectContributor;

    public WrapperElementPropertySource(Class objectContributor, Element element) {
        this.myObjectContributor = objectContributor;
        this.myElement = element;
        this.myId2Properties = new HashMap();
    }

    public Object getEditableValue() {
        return this.myElement;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.myElement.isDeleted()) {
            return new IPropertyDescriptor[0];
        }
        ArrayList<DefaultPropertyDescriptor> list = new ArrayList<DefaultPropertyDescriptor>();
        if (this.myElement.hasProperty("$property_descriptor")) {
            PropertyEnumeration propertyEnumeration = this.myElement.properties("$property_descriptor");
            while (propertyEnumeration.hasMoreElements()) {
                Property property = propertyEnumeration.next();
                PropertyMap pm = property.getSubproperties();
                AutoConfigurablePropertySet properties = new AutoConfigurablePropertySet(pm);
                properties.setObjects(new Object[]{this.myElement});
                Object id = properties.getIds()[0];
                this.myId2Properties.put(id, properties);
                Element parameter = this.myElement;
                if (parameter instanceof Reference) {
                    parameter = ((Reference)parameter).getEntity();
                }
                list.add(new DefaultPropertyDescriptor(properties, id, parameter));
            }
            IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[list.size()];
            list.toArray(propertyDescriptors);
            return propertyDescriptors;
        }
        IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[list.size()];
        list.toArray(propertyDescriptors);
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        IPropertySet properties = (IPropertySet)this.myId2Properties.get(id);
        if (properties != null) {
            return properties.getValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        IPropertySet properties = (IPropertySet)this.myId2Properties.get(id);
        if (properties != null) {
            properties.setValue(id, value);
        }
    }
}

