/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.ui.IElementWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ui.IActionFilter;

public final class WrapperActionFilter
implements IActionFilter {
    private final HashMap myFilters = new HashMap(21);
    private static WrapperActionFilter myInstance;
    private static final String CLASS = "class";
    private static final String ELEMENT_ON_DIAGRAM = "elementOnDiagram";
    private static final String DIAGRAM_ACCESSIBLE = "diagramAccessible";
    private static final String REFERENCE = "reference";
    private static final String METACLASS = "metaclass";
    private static final String HAS_JAVA_NATURE = "hasJavaNature";
    private static final String PARENT_HAS_PROPERTY = "parentHasProperty";
    private static final String HAS_PROPERTY = "hasProperty";
    private static final String HAS_PROPERTY_VALUE = "hasPropertyValue";
    private static final String HAS_OBJECT_PROPERTY = "hasObjectProperty";
    private static final String IS_LINK = "isLink";
    private static final String NOT_PREFIX = "!";
    private static final String VIEW = "view";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String SHORTCUT = "shortcut";
    private static final String ELEMENT_WITH_STEREOTYPE = "withStereotype";

    private WrapperActionFilter() {
        this.myFilters.put(DIAGRAM_ACCESSIBLE, new DiagramAccessible());
        this.myFilters.put(CLASS, new Class());
        this.myFilters.put(METACLASS, new Metaclass());
        this.myFilters.put(REFERENCE, new ReferenceFilter());
        this.myFilters.put(PARENT_HAS_PROPERTY, new ParentHasProperty());
        this.myFilters.put(HAS_PROPERTY, new HasProperty());
        this.myFilters.put(HAS_PROPERTY_VALUE, new HasPropertyValue());
        this.myFilters.put(HAS_OBJECT_PROPERTY, new HasObjectProperty());
        this.myFilters.put(HAS_JAVA_NATURE, new HasJavaNature());
        this.myFilters.put(IS_LINK, new IsLink());
        this.myFilters.put(VIEW, new View());
        this.myFilters.put(PROJECT_NATURE, new ProjectNature());
        this.myFilters.put(SHORTCUT, new Shortcut());
        this.myFilters.put(ELEMENT_ON_DIAGRAM, new ElementOnDiagram());
        this.myFilters.put(ELEMENT_WITH_STEREOTYPE, new ElementWithStereotype());
    }

    public static WrapperActionFilter getInstance() {
        if (myInstance == null) {
            myInstance = new WrapperActionFilter();
        }
        return myInstance;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Filter filter;
        boolean not = false;
        if (name.startsWith(NOT_PREFIX)) {
            name = name.substring(NOT_PREFIX.length());
            not = true;
        }
        if ((filter = (Filter)this.myFilters.get(name)) == null) {
            return false;
        }
        if (!(target instanceof IElementWrapper)) {
            return false;
        }
        filter.not = not;
        filter.target = (IElementWrapper)target;
        filter.element = filter.target.getResolvedElement();
        if (filter.element == null) {
            return false;
        }
        return filter.calculateResult(value);
    }

    static List getValuesList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    static boolean checkProperties(Element element, String values, boolean isSet) {
        List list = WrapperActionFilter.getValuesList(values);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            String property = (String)itr.next();
            if (!(isSet ? !element.hasProperty(property) : element.hasProperty(property))) continue;
            return false;
        }
        return true;
    }

    private static String[] getPropertyNameAndValue(String condition) {
        if (condition == null) {
            return null;
        }
        int index = condition.indexOf(61);
        if (index < 0) {
            return null;
        }
        String name = condition.substring(0, index);
        String value = condition.substring(index + 1);
        return new String[]{name, value};
    }

    static boolean checkPropertyValues(Element element, String values, boolean isSet) {
        String[] nameAndValue = WrapperActionFilter.getPropertyNameAndValue(values);
        if (nameAndValue == null) {
            return false;
        }
        String name = nameAndValue[0];
        String value = nameAndValue[1];
        return element.hasPropertyValue(name, value) == isSet;
    }

    static boolean checkObjectProperties(Element element, String values, boolean isSet) {
        List list = WrapperActionFilter.getValuesList(values);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            String property = (String)itr.next();
            if (!(isSet ? element.getObjectPropertyValue(property) == null : element.getObjectPropertyValue(property) != null)) continue;
            return false;
        }
        return true;
    }

    private class ElementWithStereotype
    extends Filter {
        private ElementWithStereotype() {
        }

        boolean calculateResult(String value) {
            List values = WrapperActionFilter.getValuesList(value);
            boolean has = false;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                String nextValue = (String)it.next();
                if (!this.element.hasPropertyValue("@stereotype", nextValue)) continue;
                has = true;
                break;
            }
            return this.not ^ has;
        }
    }

    private class ElementOnDiagram
    extends Filter {
        private ElementOnDiagram() {
        }

        boolean calculateResult(String value) {
            boolean result = this.target.getOriginalElement() instanceof Reference && this.element instanceof ReferenceCollection;
            boolean flag = Boolean.valueOf(value);
            if (this.not) {
                return result != flag;
            }
            return result == flag;
        }
    }

    private class Shortcut
    extends Filter {
        private Shortcut() {
        }

        boolean calculateResult(String value) {
            boolean reference = this.target.getOriginalElement() instanceof Reference;
            boolean result = !((reference &= this.target.getOriginalElement().getPropertyValue("$imported") != null) ^ Boolean.valueOf(value));
            return this.not ^ result;
        }
    }

    private class ProjectNature
    extends Filter {
        private ProjectNature() {
        }

        boolean calculateResult(String value) {
            PropertyEnumeration natures = this.element.getModel().properties("$nature");
            boolean flag = false;
            while (natures.hasMoreElements()) {
                if (!value.equals(natures.next().getValue())) continue;
                flag = true;
            }
            return this.not ^ flag;
        }
    }

    private class View
    extends Filter {
        private View() {
        }

        boolean calculateResult(String value) {
            String sourceView = this.target.getViewID();
            if (this.not) {
                return value.indexOf(sourceView) < 0;
            }
            return value.indexOf(sourceView) >= 0;
        }
    }

    private class IsLink
    extends Filter {
        private IsLink() {
        }

        boolean calculateResult(String value) {
            UniqueName uniqueName = this.element.getUniqueName();
            String subDoimain = uniqueName.getSubDomain();
            boolean isLink = subDoimain != null && (subDoimain.startsWith("link") || subDoimain.startsWith("l_"));
            boolean flag = Boolean.valueOf(value);
            if (this.not) {
                return isLink != flag;
            }
            return isLink == flag;
        }
    }

    private class HasJavaNature
    extends Filter {
        private HasJavaNature() {
        }

        boolean calculateResult(String value) {
            boolean flag;
            if (this.element instanceof ReferenceCollection) {
                this.element = ((ReferenceCollection)this.element).getParent();
            }
            return !((flag = Boolean.valueOf(value).booleanValue()) ^ this.element.hasProperty("$java_element"));
        }
    }

    private class HasPropertyValue
    extends Filter {
        private HasPropertyValue() {
        }

        boolean calculateResult(String value) {
            if (this.element instanceof ReferenceCollection) {
                this.element = ((ReferenceCollection)this.element).getParent();
            }
            return WrapperActionFilter.checkPropertyValues(this.element, value, this.not);
        }
    }

    private class HasObjectProperty
    extends Filter {
        private HasObjectProperty() {
        }

        boolean calculateResult(String value) {
            if (this.element instanceof ReferenceCollection) {
                this.element = ((ReferenceCollection)this.element).getParent();
            }
            return WrapperActionFilter.checkObjectProperties(this.element, value, !this.not);
        }
    }

    private class HasProperty
    extends Filter {
        private HasProperty() {
        }

        boolean calculateResult(String value) {
            if (this.element instanceof ReferenceCollection) {
                this.element = ((ReferenceCollection)this.element).getParent();
            }
            return WrapperActionFilter.checkProperties(this.element, value, !this.not);
        }
    }

    private class ParentHasProperty
    extends Filter {
        private ParentHasProperty() {
        }

        boolean calculateResult(String value) {
            this.element = this.element.getParent();
            if (this.element == null) {
                return false;
            }
            return this.not ^ this.element.hasProperty(value);
        }
    }

    private class ReferenceFilter
    extends Filter {
        private ReferenceFilter() {
        }

        boolean calculateResult(String value) {
            boolean reference = this.target.getOriginalElement() instanceof Reference;
            boolean result = !(Boolean.valueOf(value) ^ reference);
            return this.not ^ result;
        }
    }

    private class Metaclass
    extends Filter {
        private Metaclass() {
        }

        boolean calculateResult(String value) {
            List list = WrapperActionFilter.getValuesList(value);
            String val = this.element.getPropertyValue("$metaclass");
            return this.not ^ list.contains(val);
        }
    }

    private class Class
    extends Filter {
        private Class() {
        }

        boolean calculateResult(String value) {
            List list = WrapperActionFilter.getValuesList(value);
            String clazz = null;
            if (this.element instanceof ReferenceCollection) {
                if (this.element instanceof ReferenceCollection && this.element.hasProperty("automaticallySynchronized")) {
                    this.element = this.element.getParent();
                }
                clazz = this.element instanceof Model ? "Model" : "ReferenceCollection";
            } else if (this.element instanceof Model) {
                clazz = "Model";
            } else if (this.element instanceof Entity) {
                clazz = "Entity";
            }
            return this.not ^ list.contains(clazz);
        }
    }

    private class DiagramAccessible
    extends Filter {
        private DiagramAccessible() {
        }

        boolean calculateResult(String value) {
            boolean shouldBe = Boolean.valueOf(value);
            boolean realState = this.element instanceof ReferenceCollection || this.element.hasProperty("DiagramUIN");
            return shouldBe == realState;
        }
    }

    private static abstract class Filter {
        IElementWrapper target;
        Element element;
        boolean not;

        private Filter() {
        }

        abstract boolean calculateResult(String var1);
    }
}

