/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui;

import com.tssap.selena.model.ui.ModelSelectionListener;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ModelSelectionService
implements ISelectionListener {
    private HashSet myListeners = new HashSet();
    private IWorkbenchWindow myWorkbenchWindow;

    public ModelSelectionService(IWorkbenchWindow window) {
        this.myWorkbenchWindow = window;
        this.myWorkbenchWindow.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void shutDown() {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.clear();
        }
        this.myWorkbenchWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void addModelSelectionListener(ModelSelectionListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.add(listener);
        }
    }

    public void removeModelSelectionListener(ModelSelectionListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.remove(listener);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.myListeners.isEmpty()) {
            return;
        }
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            ModelSelectionListener[] listeners = ((AbstractCollection)this.myListeners).toArray(new ModelSelectionListener[this.myListeners.size()]);
            int i = 0;
            while (i < listeners.length) {
                ModelSelectionListener curListener = listeners[i];
                IViewPart curViewPart = curListener.getListenerPart();
                if (curViewPart != part) {
                    curListener.selectionChanged(part, selection);
                }
                ++i;
            }
        }
    }
}

