/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui;

import com.tssap.selena.internal.model.ui.Util;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.ui.Messages;
import com.tssap.selena.model.ui.property.IPropertySet;

public class AutoConfigurablePropertySet
implements IPropertySet {
    private Object[] myObects;
    private String myName = "no name";
    private String myModelProperty = "no name";
    private String mySupport;
    private boolean myReadOnly;
    private String myGroup;
    private String myDescription;
    private String[] myFilterFlags;
    private String myHelpContextIds;

    public AutoConfigurablePropertySet(PropertyMap propertyMap) {
        this.myName = propertyMap.getPropertyValue("name");
        if ("".equals(this.myName)) {
            Util.skippedMsg("name", this);
        }
        this.myModelProperty = propertyMap.getPropertyValue("modelProperty");
        if ("".equals(this.myModelProperty)) {
            Util.skippedMsg("modelProperty", this);
        }
        this.mySupport = propertyMap.getPropertyValue("support");
        this.myReadOnly = propertyMap.hasProperty("readOnly");
        this.myGroup = propertyMap.getPropertyValue("group");
        this.myDescription = propertyMap.getPropertyValue("description");
        this.myFilterFlags = Util.str2Array(propertyMap.getPropertyValue("filterFlags"));
        this.myHelpContextIds = propertyMap.getPropertyValue("helpContextIds");
    }

    public Object[] getObjects() {
        return this.myObects;
    }

    public void setObjects(Object[] obects) {
        this.myObects = obects;
    }

    public String getCategory(Object id) {
        return this.myGroup;
    }

    public String getDescription(Object id) {
        return this.myDescription;
    }

    public String getDisplayName(Object id) {
        return this.myName;
    }

    public String[] getFilterFlags(Object id) {
        return this.myFilterFlags;
    }

    public String getHelpContextIds(Object id) {
        return this.myHelpContextIds;
    }

    public Object[] getIds() {
        return new Object[]{"" + this.hashCode()};
    }

    public String getSupport(Object id) {
        return this.mySupport;
    }

    public boolean isApplicable() {
        return true;
    }

    public boolean isReadonly(Object id) {
        return false;
    }

    public Object getValue(Object id) {
        PropertyMap propertyMap = this.getPropertyMap();
        if (propertyMap != null) {
            return propertyMap.getPropertyValue(this.myModelProperty);
        }
        return null;
    }

    public String isValidValue(Object id, Object value) {
        PropertyMap propertyMap = this.getPropertyMap();
        if (propertyMap != null && (value instanceof String ? !propertyMap.canSetPropertyValue(this.myModelProperty, (String)value) : value instanceof Boolean && !propertyMap.canSetPropertyValue(this.myModelProperty, this.getStringValue((Boolean)value)))) {
            return Messages.getString("AutoConfigurablePropertySet.UnableToSetValue");
        }
        return Messages.getString("AutoConfigurablePropertySet.It_should_be_either___java.lang.String___or___java.lang.Boolean___value");
    }

    public void setValue(Object id, Object value) {
        PropertyMap propertyMap = this.getPropertyMap();
        if (propertyMap != null) {
            if (value instanceof String) {
                propertyMap.setPropertyValue(this.myModelProperty, (String)value);
            } else if (value instanceof Boolean) {
                propertyMap.setPropertyValue(this.myModelProperty, this.getStringValue((Boolean)value));
            }
        }
    }

    public void setConfigurationElement(Object element) {
    }

    public boolean equalsTo(IPropertySet propertySet) {
        return false;
    }

    public Integer getOverrideRank() {
        return new Integer(0);
    }

    private PropertyMap getPropertyMap() {
        if (this.myObects != null && this.myObects.length > 0) {
            return (PropertyMap)this.myObects[0];
        }
        return null;
    }

    private String getStringValue(Boolean value) {
        return value != false ? Boolean.TRUE.toString() : null;
    }
}

