/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.keyboardShortcuts;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.internal.model.ui.keyboardShortcuts.GlobalActionHandlerAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionDelegate;

public class ShortcutsRegistry {
    private static String SHORTCUTS_EXTENSION_POINT = "keyboardShortcuts";
    private static String POPUPS_MENU_ELEMENT = "org.eclipse.ui.popupMenus";
    private static String OBJECT_CONTRIBUTION_ELEMENT = "objectContribution";
    private static String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    private static String ACTION_ELEMENT = "action";
    private static String LABEL_ATTRIBUTE = "label";
    private static String CLASS_ATTRIBUTE = "class";
    private static String DEFINITION_ID_ATTRIBUTE = "definitionId";
    private static String UNDO_TRANSPARENT_ATTRIBUTE = "undoTransparentFromKeyboard";
    private static String SHORTCUT_LABEL_SEPARATOR = "@";
    private static String[] KNOWN_OBJECT_CLASSES = new String[]{(class$com$tssap$selena$model$ui$IElementWrapper == null ? (class$com$tssap$selena$model$ui$IElementWrapper = ShortcutsRegistry.class$("com.tssap.selena.model.ui.IElementWrapper")) : class$com$tssap$selena$model$ui$IElementWrapper).getName(), "com.tssap.selena.gde.EditPartElementWrapper"};
    private static ShortcutsRegistry myRegistry = null;
    private Map myShortcuts = new HashMap();
    static /* synthetic */ Class class$com$tssap$selena$model$ui$IElementWrapper;

    public static ShortcutsRegistry getInstance() {
        if (myRegistry == null) {
            myRegistry = new ShortcutsRegistry();
        }
        return myRegistry;
    }

    public boolean containsAction(String definitionID) {
        if (definitionID == null || definitionID.equals("")) {
            return false;
        }
        return this.myShortcuts.containsKey(definitionID);
    }

    public IAction getAction(String definitionID) {
        return (IAction)this.myShortcuts.get(definitionID);
    }

    public IAction[] getActions() {
        Collection actions = this.myShortcuts.values();
        return actions.toArray(new IAction[actions.size()]);
    }

    private ShortcutsRegistry() {
        IConfigurationElement[] popupMenuElements = Platform.getPluginRegistry().getConfigurationElementsFor(POPUPS_MENU_ELEMENT);
        int i = 0;
        while (i < popupMenuElements.length) {
            if (OBJECT_CONTRIBUTION_ELEMENT.equals(popupMenuElements[i].getName())) {
                String contributionClassName = popupMenuElements[i].getAttribute(OBJECT_CLASS_ATTRIBUTE);
                int j = 0;
                while (j < KNOWN_OBJECT_CLASSES.length) {
                    if (KNOWN_OBJECT_CLASSES[j].equals(contributionClassName)) {
                        this.readObjectContribution(popupMenuElements[i]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        IExtensionPoint shortcutsExtPoint = ModelUIPlugin.getDefault().getDescriptor().getExtensionPoint(SHORTCUTS_EXTENSION_POINT);
        if (shortcutsExtPoint != null) {
            IConfigurationElement[] actionElements = shortcutsExtPoint.getConfigurationElements();
            int i2 = 0;
            while (i2 < actionElements.length) {
                if (ACTION_ELEMENT.equals(actionElements[i2].getName())) {
                    this.addAction(actionElements[i2]);
                }
                ++i2;
            }
        }
    }

    private void readObjectContribution(IConfigurationElement configElement) {
        IConfigurationElement[] actions = configElement.getChildren(ACTION_ELEMENT);
        int i = 0;
        while (i < actions.length) {
            this.addAction(actions[i]);
            ++i;
        }
    }

    private void addAction(IConfigurationElement actionElement) {
        String definitionId = actionElement.getAttribute(DEFINITION_ID_ATTRIBUTE);
        if (definitionId == null || definitionId.equals("")) {
            return;
        }
        if (this.myShortcuts.containsKey(definitionId)) {
            ModelUIPlugin.getDefault().log("Several actions are registered with the same definitionId: " + definitionId);
        }
        try {
            Object action = actionElement.createExecutableExtension(CLASS_ATTRIBUTE);
            if (action instanceof IActionDelegate) {
                String actionLabel;
                if (action instanceof IExecutableExtension) {
                    ((IExecutableExtension)action).setInitializationData(actionElement, CLASS_ATTRIBUTE, null);
                }
                if ((actionLabel = actionElement.getAttribute(LABEL_ATTRIBUTE)) == null) {
                    actionLabel = "";
                }
                boolean undoTransparent = Boolean.TRUE.toString().equalsIgnoreCase(actionElement.getAttribute(UNDO_TRANSPARENT_ATTRIBUTE));
                GlobalActionHandlerAction handlerAction = new GlobalActionHandlerAction((IActionDelegate)action, actionLabel, undoTransparent);
                handlerAction.setActionDefinitionId(definitionId);
                this.myShortcuts.put(definitionId, handlerAction);
            } else if (action instanceof IAction) {
                ((IAction)action).setActionDefinitionId(definitionId);
                this.myShortcuts.put(definitionId, action);
            }
        }
        catch (CoreException creatingActionException) {
            creatingActionException.printStackTrace();
        }
        catch (Throwable fatalError) {
            fatalError.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

