/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.keyboardShortcuts;

import com.tssap.selena.internal.model.ui.keyboardShortcuts.HotkeyActionListener;
import com.tssap.selena.internal.model.ui.keyboardShortcuts.ShortcutsRegistry;
import com.tssap.selena.model.ui.actions.ITextActionsViewPart;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class KeyboardNotifier {
    private static final String TSSAP_SCOPE = "com.tssap.diagramModelingScope";
    private static KeyboardNotifier myInstance = null;
    private static boolean myAddFlag = true;
    private Set myActionListeners = new HashSet();
    private Map myGlobalActions = null;
    private IAction myProbeAction = new Action(){};

    public static KeyboardNotifier getInstance() {
        if (myInstance == null) {
            myInstance = new KeyboardNotifier();
        }
        return myInstance;
    }

    private KeyboardNotifier() {
    }

    public void hookGlobalActions(IViewPart viewPart) {
        TextActionHandlerExt handler;
        this.hookGlobalActions(viewPart.getViewSite());
        if (viewPart instanceof ITextActionsViewPart && (handler = ((ITextActionsViewPart)viewPart).getTextActionHandler()) != null) {
            KeyboardNotifier.bindAction(viewPart, handler.getDeleteActionHandler());
            KeyboardNotifier.bindAction(viewPart, handler.getCopyActionHandler());
            KeyboardNotifier.bindAction(viewPart, handler.getCutActionHandler());
            KeyboardNotifier.bindAction(viewPart, handler.getPasteActionHandler());
        }
    }

    private static void bindAction(IViewPart viewPart, IAction action) {
        if (action != null) {
            viewPart.getViewSite().getKeyBindingService().registerAction(action);
        }
    }

    public void hookGlobalActions(IViewSite site) {
        IWorkbenchWindow iWWindow;
        site.getKeyBindingService().setScopes(new String[]{TSSAP_SCOPE});
        IAction[] actions = ShortcutsRegistry.getInstance().getActions();
        int i = 0;
        while (i < actions.length) {
            site.getKeyBindingService().registerAction(actions[i]);
            ++i;
        }
        IActionBars actionbars = site.getActionBars();
        if (actionbars != null && (iWWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) instanceof WorkbenchWindow) {
            MenuManager menuManager = ((WorkbenchWindow)iWWindow).getMenuBarManager();
            this.mapGlobalActions((IMenuManager)menuManager, actionbars);
        }
    }

    public void keyPressed(KeyEvent event, IViewPart viewPart) {
    }

    public synchronized void addHotkeyActionListener(HotkeyActionListener listener) {
        if (listener != null) {
            this.myActionListeners.add(listener);
        }
    }

    public synchronized void removeHotkeyActionListener(HotkeyActionListener listener) {
        if (listener != null) {
            this.myActionListeners.remove(listener);
        }
    }

    public void fireActionListeners() {
        HotkeyActionListener[] listeners;
        KeyboardNotifier keyboardNotifier = this;
        synchronized (keyboardNotifier) {
            listeners = this.myActionListeners.toArray(new HotkeyActionListener[this.myActionListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].beforeStart();
            ++i;
        }
    }

    private void mapGlobalActions(IMenuManager menuManager, IActionBars actionbars) {
        IContributionItem[] items = menuManager.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof IMenuManager) {
                this.mapGlobalActions((IMenuManager)items[i], actionbars);
            } else if (items[i] instanceof ActionContributionItem) {
                IAction nextAction = ((ActionContributionItem)items[i]).getAction();
                String definitionID = nextAction.getActionDefinitionId();
                if (ShortcutsRegistry.getInstance().containsAction(definitionID)) {
                    IAction action = ShortcutsRegistry.getInstance().getAction(definitionID);
                    actionbars.setGlobalActionHandler(nextAction.getId(), action);
                    if (action instanceof ISelectionListener) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)action);
                    }
                }
            }
            ++i;
        }
    }
}

