/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.ui.property.element.stereotype.DefaultStereotypeDescriptor;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypeDescriptor;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.RGB;

public class StereotypeRegistryReader {
    static final String TAG_ELEMENT = "element";
    static final String ATT_ELEMENT_METACLASS = "metaclass";
    static final String TAG_STEREOTYPE = "stereotype";
    static final String ATT_ST_NAME = "name";
    static final String ATT_ST_NATURE = "nature";
    static final String ATT_ST_MANDATORY = "mandatory";
    static final String ATT_ST_COLOR = "color";
    private static StereotypeRegistryReader myInstance;
    private HashMap myStereotypes = null;
    static /* synthetic */ Class class$org$eclipse$swt$graphics$RGB;

    public static StereotypeRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new StereotypeRegistryReader();
        }
        return myInstance;
    }

    public IStereotypeDescriptor[] getStereotypes(String metaclass, String[] natures) {
        if (this.myStereotypes == null) {
            this.myStereotypes = new HashMap();
            this.readRegistry();
        }
        ArrayList completeList = new ArrayList();
        Iterator exts = this.myStereotypes.keySet().iterator();
        while (exts.hasNext()) {
            String extId = (String)exts.next();
            HashMap metastereoMap = (HashMap)this.myStereotypes.get(extId);
            ArrayList partialList = (ArrayList)metastereoMap.get(metaclass + ".*");
            if (partialList != null) {
                completeList.addAll(partialList);
            }
            int i = 0;
            while (i < natures.length) {
                if (natures[i] != null && !natures[i].equals("") && (partialList = (ArrayList)metastereoMap.get(metaclass + "." + natures[i])) != null) {
                    completeList.addAll(partialList);
                }
                ++i;
            }
        }
        IStereotypeDescriptor[] stereotypes = new IStereotypeDescriptor[completeList.size()];
        completeList.toArray(stereotypes);
        return stereotypes;
    }

    private void readRegistry() {
        String extensionPoint;
        String pluginID;
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pluginID = ModelUIPlugin.getPluginID(), extensionPoint = "stereotypes");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            IConfigurationElement[] elements = null;
            int i = 0;
            while (i < extensions.length) {
                elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    this.readElement(elements[j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_ELEMENT.equals(element.getName())) {
            this.registerMetaclass(element);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            this.readElement(children[i]);
            ++i;
        }
    }

    private void registerMetaclass(IConfigurationElement element) {
        String extId = element.getDeclaringExtension().getUniqueIdentifier();
        String stMetaclasses = element.getAttribute(ATT_ELEMENT_METACLASS);
        if (stMetaclasses != null) {
            StringTokenizer st = new StringTokenizer(stMetaclasses, ",");
            while (st.hasMoreTokens()) {
                String metaclass = st.nextToken().trim();
                IConfigurationElement[] stereotypes = element.getChildren(TAG_STEREOTYPE);
                int i = 0;
                while (i < stereotypes.length) {
                    this.registerStereotype(stereotypes[i], metaclass);
                    ++i;
                }
            }
        }
    }

    private void registerStereotype(IConfigurationElement element, String metaclass) {
        String stName;
        boolean stMandatory = false;
        String stMandatoryAttr = element.getAttribute(ATT_ST_MANDATORY);
        if (stMandatoryAttr != null && stMandatoryAttr.equalsIgnoreCase("true")) {
            stMandatory = true;
        }
        RGB color = null;
        String stColorAttr = element.getAttribute(ATT_ST_COLOR);
        if (stColorAttr != null) {
            IPropertyMarshaler marshaler = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$swt$graphics$RGB == null ? (class$org$eclipse$swt$graphics$RGB = StereotypeRegistryReader.class$("org.eclipse.swt.graphics.RGB")) : class$org$eclipse$swt$graphics$RGB).getName());
            color = (RGB)marshaler.unmarshal(stColorAttr);
        }
        if ((stName = element.getAttribute(ATT_ST_NAME)) != null) {
            String metastereoKey;
            ArrayList<DefaultStereotypeDescriptor> slist;
            String extId;
            HashMap<String, ArrayList<DefaultStereotypeDescriptor>> metastereoMap;
            String stNature = element.getAttribute(ATT_ST_NATURE);
            if (stNature == null || stNature.equals("")) {
                stNature = "*";
            }
            if ((metastereoMap = (HashMap<String, ArrayList<DefaultStereotypeDescriptor>>)this.myStereotypes.get(extId = element.getDeclaringExtension().getUniqueIdentifier())) == null) {
                metastereoMap = new HashMap<String, ArrayList<DefaultStereotypeDescriptor>>();
                this.myStereotypes.put(extId, metastereoMap);
            }
            if ((slist = (ArrayList<DefaultStereotypeDescriptor>)metastereoMap.get(metastereoKey = metaclass + "." + stNature)) == null) {
                slist = new ArrayList<DefaultStereotypeDescriptor>();
                metastereoMap.put(metastereoKey, slist);
            }
            slist.add(new DefaultStereotypeDescriptor(stName, stMandatory, color));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

