/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.update.diagram.DispatchedTreeDeltaListener;
import com.tssap.selena.model.update.hierarchy.DeltaDispatcher;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

class PropertySheetUpdater
implements ISelectionListener {
    private static Element myPreviousElement = null;
    private static ArrayList myPreviousParentChain = new ArrayList();
    private static MyModelDeltaListener ourModelDeltaListener;
    private static MyElementDeltaListener ourElementDeltaListener;
    private static String ID;

    PropertySheetUpdater() {
        ourModelDeltaListener = new MyModelDeltaListener();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof PropertySheet) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Model model;
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
                selection = new StructuredSelection(new Object());
                if (PropertySheetUpdater.getPropertySheet() != null) {
                    PropertySheetUpdater.getPropertySheet().selectionChanged(part, selection);
                }
                return;
            }
            if (myPreviousElement != null && !myPreviousElement.isDeleted() && (model = myPreviousElement.getModel()) != null && !model.isDeleted()) {
                UniqueName uniqueName = model.getUniqueName();
                DeltaDispatcher.getInstance((UniqueName)uniqueName).removeListener(myPreviousElement, (DispatchedTreeDeltaListener)ourModelDeltaListener);
                DeltaDispatcher.getInstance((UniqueName)uniqueName).removeListener(myPreviousElement, (DispatchedTreeDeltaListener)ourElementDeltaListener);
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator itr = structuredSelection.iterator();
            ArrayList list = new ArrayList();
            while (itr.hasNext()) {
                Object object = itr.next();
                if (!(object instanceof DefaultElementWrapper)) continue;
                list.add(object);
            }
            if (!list.isEmpty()) {
                int i = 0;
                while (i < list.size()) {
                    Entity element = ((DefaultElementWrapper)list.get(i)).getResolvedElement();
                    myPreviousElement = element;
                    if (element != null) {
                        PropertySheetUpdater.buildParentChain(myPreviousElement);
                        Model model2 = element.getModel();
                        if (model2 != null && !model2.isDeleted()) {
                            UniqueName uniqueName = model2.getUniqueName();
                            DeltaDispatcher.getInstance((UniqueName)model2.getUniqueName()).registerListener((Element)model2, (DispatchedTreeDeltaListener)ourModelDeltaListener);
                            if (ourElementDeltaListener != null) {
                                PropertySheetUpdater.ourElementDeltaListener.unregisterDispatchedDeltaListener();
                            }
                            ourElementDeltaListener = new MyElementDeltaListener(model2, (Element)element, part);
                        }
                    }
                    ++i;
                }
            }
        } else {
            PropertySheetUpdater.refreshPropertySheet();
        }
    }

    private static void refreshPropertySheet() {
        PropertySheet propertySheet = PropertySheetUpdater.getPropertySheet();
        if (propertySheet != null && propertySheet.getCurrentPage() instanceof PropertySheetPage) {
            PropertySheetPage propertySheetPage = (PropertySheetPage)propertySheet.getCurrentPage();
            if (myPreviousElement != null && myPreviousElement.isDeleted()) {
                return;
            }
            propertySheetPage.refresh();
        }
    }

    private static PropertySheet getPropertySheet() {
        IViewPart view;
        IWorkbenchPage page = ModelUIPlugin.getWorkbenchPage();
        if (page != null && (view = page.findView(ID)) != null) {
            PropertySheet propertySheet = (PropertySheet)view;
            return propertySheet;
        }
        return null;
    }

    private static void buildParentChain(Element element) {
        myPreviousParentChain.clear();
        while (element.getParent() != null) {
            element = element.getParent();
            myPreviousParentChain.add(element);
        }
    }

    private static Element getValidParent() {
        int i = 0;
        while (i < myPreviousParentChain.size()) {
            Element element = (Element)myPreviousParentChain.get(i);
            if (element != null && !element.isDeleted()) {
                return element;
            }
            ++i;
        }
        return null;
    }

    static {
        ID = "org.eclipse.ui.views.PropertySheet";
    }

    private class MyElementDeltaListener
    implements DispatchedTreeDeltaListener,
    IPartListener {
        private Model myModel;
        private UniqueName myElementUin;
        private IWorkbenchPart myPart;

        MyElementDeltaListener(Model model, Element element, IWorkbenchPart part) {
            this.myModel = model;
            this.myElementUin = element == null ? null : element.getUniqueName();
            this.myPart = part;
            IWorkbenchPage workbenchPage = ModelUIPlugin.getWorkbenchPage();
            if (workbenchPage != null) {
                workbenchPage.addPartListener((IPartListener)this);
            }
            DeltaDispatcher.getInstance((UniqueName)model.getUniqueName()).registerListener(element, (DispatchedTreeDeltaListener)this);
        }

        public void dispatchingChainCorrupted(ModelDeltaNode deltaNode) {
            this.modelChanged(deltaNode);
        }

        public void modelChanged(ModelDeltaNode dispatchedDelta) {
            UniqueName elementUniqueName = dispatchedDelta.getElementUniqueName();
            UniqueName originalElementUniqueName = dispatchedDelta.getOriginalElementUniqueName();
            StructuredSelection selection = null;
            if (originalElementUniqueName != null && !originalElementUniqueName.equals(elementUniqueName)) {
                Entity originalEntity = this.myModel.findEntity(originalElementUniqueName);
                selection = originalEntity != null ? new StructuredSelection((Object)new DefaultElementWrapper((Element)originalEntity)) : StructuredSelection.EMPTY;
                this.selectionChanged((ISelection)selection);
                StructuredSelection fSelection = selection;
                ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand((ISelection)fSelection){
                    private final /* synthetic */ ISelection val$fSelection;
                    {
                        this.val$fSelection = val$fSelection;
                    }

                    public void run() {
                        PropertySheetUpdater.this.selectionChanged(myPart, this.val$fSelection);
                    }
                });
                return;
            }
            if (dispatchedDelta.isDeleted()) {
                Element parentElement = PropertySheetUpdater.getValidParent();
                selection = parentElement != null ? new StructuredSelection((Object)new DefaultElementWrapper(parentElement)) : StructuredSelection.EMPTY;
                this.selectionChanged((ISelection)selection);
                StructuredSelection fSelection = selection;
                ModelAccess.runCommandLater((Runnable)new Runnable(this, (ISelection)fSelection){
                    private final /* synthetic */ ISelection val$fSelection;
                    private final /* synthetic */ MyElementDeltaListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$fSelection = val$fSelection;
                    }

                    public void run() {
                        MyElementDeltaListener.access$400(this.this$1).selectionChanged(MyElementDeltaListener.access$300(this.this$1), this.val$fSelection);
                    }
                });
                return;
            }
        }

        private void selectionChanged(ISelection selection) {
            PropertySheet propertySheet;
            if (selection != null && (propertySheet = PropertySheetUpdater.getPropertySheet()) != null) {
                propertySheet.selectionChanged(this.myPart, selection);
            }
        }

        private void unregisterDispatchedDeltaListener() {
            IWorkbenchPage workbenchPage = ModelUIPlugin.getWorkbenchPage();
            if (workbenchPage != null) {
                workbenchPage.removePartListener((IPartListener)this);
            }
            if (this.myModel != null && this.myElementUin != null) {
                DeltaDispatcher.getInstance((UniqueName)this.myModel.getUniqueName()).removeListener(this.myElementUin, (DispatchedTreeDeltaListener)this);
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (ID.equals(part.getSite().getId())) {
                this.unregisterDispatchedDeltaListener();
                this.myPart = null;
                this.myModel = null;
                this.myElementUin = null;
            }
        }
    }

    private class MyModelDeltaListener
    implements DispatchedTreeDeltaListener {
        private MyModelDeltaListener() {
        }

        public void modelChanged(ModelDeltaNode dispatchedDelta) {
            PropertySheetUpdater.refreshPropertySheet();
        }

        public void dispatchingChainCorrupted(ModelDeltaNode deltaNode) {
            PropertySheetUpdater.refreshPropertySheet();
        }
    }
}

