/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

class PropertySheetLayouter
implements ISelectionListener {
    private static boolean myNesLayoutSet = false;
    private static String ID = "org.eclipse.ui.views.PropertySheet";

    PropertySheetLayouter() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        PropertySheet propertySheet;
        if (part instanceof PropertySheet) {
            return;
        }
        if (!myNesLayoutSet && (propertySheet = PropertySheetLayouter.getPropertySheet()) != null) {
            PropertySheetLayouter.setPropertySheetLayouter(propertySheet);
            myNesLayoutSet = true;
        }
    }

    private static void setPropertySheetLayouter(PropertySheet propertySheet) {
        PropertySheetPage propertySheetPage = (PropertySheetPage)propertySheet.getCurrentPage();
        TableTree tableTree = (TableTree)propertySheetPage.getControl();
        ColumnWeightData c1Layout = new ColumnWeightData(40, false);
        ColumnWeightData c2Layout = new ColumnWeightData(60, true);
        MyTableLayout layout = new MyTableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        tableTree.getTable().setLayout((Layout)layout);
        tableTree.getTable().layout();
    }

    private static PropertySheet getPropertySheet() {
        IViewPart view;
        IWorkbenchPage page = ModelUIPlugin.getWorkbenchPage();
        if (page != null && (view = page.findView(ID)) != null) {
            PropertySheet propertySheet = (PropertySheet)view;
            return propertySheet;
        }
        return null;
    }

    public static class MyTableLayout
    extends Layout {
        private boolean myAvoidLayout = false;
        private List columns = new ArrayList(2);

        public void addColumnData(ColumnLayoutData data) {
            this.columns.add(data);
        }

        public Point computeSize(Composite c, int wHint, int hHint, boolean flush) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Table table = (Table)c;
            table.setLayout(null);
            Point result = table.computeSize(wHint, hHint, flush);
            table.setLayout((Layout)this);
            int width = 0;
            int size = this.columns.size();
            int i = 0;
            while (i < size) {
                ColumnPixelData col;
                ColumnLayoutData layoutData = (ColumnLayoutData)this.columns.get(i);
                if (layoutData instanceof ColumnPixelData) {
                    col = (ColumnPixelData)layoutData;
                    width += col.width;
                } else if (layoutData instanceof ColumnWeightData) {
                    col = (ColumnWeightData)layoutData;
                    width += col.minimumWidth;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
                ++i;
            }
            if (width > result.x) {
                result.x = width;
            }
            return result;
        }

        public void layout(Composite c, boolean flush) {
            if (this.myAvoidLayout) {
                return;
            }
            Table table = (Table)c;
            if (table.getHorizontalBar() == null) {
                return;
            }
            int width = table.getClientArea().width;
            if (width <= 1) {
                return;
            }
            TableColumn[] tableColumns = table.getColumns();
            int size = Math.min(this.columns.size(), tableColumns.length);
            int[] widths = new int[size];
            int fixedWidth = 0;
            int numberOfWeightColumns = 0;
            int totalWeight = 0;
            int i = 0;
            while (i < size) {
                ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i);
                if (col instanceof ColumnPixelData) {
                    int pixels;
                    widths[i] = pixels = ((ColumnPixelData)col).width;
                    fixedWidth += pixels;
                } else if (col instanceof ColumnWeightData) {
                    ColumnWeightData cw = (ColumnWeightData)col;
                    ++numberOfWeightColumns;
                    int weight = cw.weight;
                    totalWeight += weight;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
                ++i;
            }
            if (numberOfWeightColumns > 0) {
                int rest = width - fixedWidth;
                int totalDistributed = 0;
                int i2 = 0;
                while (i2 < size) {
                    ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i2);
                    if (col instanceof ColumnWeightData) {
                        int pixels;
                        ColumnWeightData cw = (ColumnWeightData)col;
                        int weight = cw.weight;
                        int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                        if (pixels < cw.minimumWidth) {
                            pixels = cw.minimumWidth;
                        }
                        totalDistributed += pixels;
                        widths[i2] = pixels;
                    }
                    ++i2;
                }
                int diff = rest - totalDistributed;
                int i3 = 0;
                while (diff > 0) {
                    ColumnLayoutData col;
                    if (i3 == size) {
                        i3 = 0;
                    }
                    if ((col = (ColumnLayoutData)this.columns.get(i3)) instanceof ColumnWeightData) {
                        int n = i3;
                        widths[n] = widths[n] + 1;
                        --diff;
                    }
                    ++i3;
                }
            }
            this.myAvoidLayout = true;
            int i4 = 0;
            while (i4 < size) {
                tableColumns[i4].setWidth(widths[i4]);
                ++i4;
            }
            this.myAvoidLayout = false;
        }
    }
}

