/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.property.IPropertySet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

class PropertyRegistryReader {
    static final String TAG_OBJECT_CLASS = "objectContribution";
    static final String ATT_OBJECT_CLASS = "objectClass";
    static final String TAG_OBJECT_METACLASS = "element";
    static final String ATT_OBJECT_METACLASS = "metaclass";
    static final String TAG_PROPERTY = "property";
    private static final Object NO_DESCRIPTORS = new HashSet(){

        public boolean add() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Object FLAG = new Object();
    private static PropertyRegistryReader myInstance;
    private static HashMap myObjectContributors;
    private static HashMap myRawObjectContributors;
    private static HashMap myPropertySetCache;
    private static final String NO_METACLASS = "";

    PropertyRegistryReader() {
    }

    public static PropertyRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new PropertyRegistryReader();
        }
        return myInstance;
    }

    static void lazyReadRegistry() {
        new ReadRegistryThread().run();
    }

    public IPropertySet[] getProperties(Class objectClass, Object object) {
        IPluginDescriptor iPluginDescriptor = ModelUIPlugin.getDefault().getDescriptor();
        synchronized (iPluginDescriptor) {
            Object object2 = FLAG;
            synchronized (object2) {
                HashSet properties;
                HashMap metaclassMap;
                if (myObjectContributors == null) {
                    myObjectContributors = new HashMap();
                    myRawObjectContributors = new HashMap();
                    myPropertySetCache = new HashMap();
                    PropertyRegistryReader.readRegistry();
                }
                String metaclass = NO_METACLASS;
                if (object instanceof Element) {
                    Element element = (Element)object;
                    metaclass = element.getPropertyValue("$metaclass");
                }
                if ((metaclassMap = (HashMap)myObjectContributors.get(objectClass)) != null && (properties = (HashSet)metaclassMap.get(metaclass)) != null) {
                    if (properties == NO_DESCRIPTORS) {
                        IPropertySet[] iPropertySetArray = new IPropertySet[]{};
                        return iPropertySetArray;
                    }
                    IPropertySet[] iPropertySetArray = this.getPropertSet(object, properties);
                    return iPropertySetArray;
                }
                if (metaclassMap == null) {
                    metaclassMap = new HashMap();
                    myObjectContributors.put(objectClass, metaclassMap);
                }
                ArrayList list = this.getOriginalMetaclassMaps(objectClass);
                int i = 0;
                while (i < list.size()) {
                    HashMap oldMetaclassMap = (HashMap)list.get(i);
                    this.addToMap(metaclass, metaclassMap, oldMetaclassMap);
                    ++i;
                }
                HashSet properties2 = (HashSet)metaclassMap.get(metaclass);
                IPropertySet[] iPropertySetArray = this.getPropertSet(object, properties2);
                return iPropertySetArray;
            }
        }
    }

    private static void readRegistry() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        String pluginID = ModelUIPlugin.getPluginID();
        String extensionPoint = ModelUIPlugin.getPropertyExtensionPoint();
        IExtensionPoint point = registry.getExtensionPoint(pluginID, extensionPoint);
        IExtension[] extensions = point.getExtensions();
        IConfigurationElement[] elements = null;
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                PropertyRegistryReader.readElement(elements[j]);
                ++j;
            }
            ++i;
        }
    }

    private static void readElement(IConfigurationElement element) {
        if (TAG_OBJECT_CLASS.equals(element.getName())) {
            PropertyRegistryReader.registerContribution(element);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            PropertyRegistryReader.readElement(children[i]);
            ++i;
        }
    }

    private static void registerContribution(IConfigurationElement element) {
        String objectContribution = element.getAttribute(ATT_OBJECT_CLASS);
        if (objectContribution != null) {
            IPluginDescriptor pd = element.getDeclaringExtension().getDeclaringPluginDescriptor();
            try {
                Class<?> contribution = pd.getPluginClassLoader().loadClass(objectContribution);
                IConfigurationElement[] propertChildren = element.getChildren(TAG_PROPERTY);
                int i = 0;
                while (i < propertChildren.length) {
                    PropertyRegistryReader.registerProperty(contribution, propertChildren[i], null);
                    ++i;
                }
                IConfigurationElement[] metaclassChildren = element.getChildren(TAG_OBJECT_METACLASS);
                if (metaclassChildren != null && metaclassChildren.length > 0) {
                    int i2 = 0;
                    while (i2 < metaclassChildren.length) {
                        String metaclass = metaclassChildren[i2].getAttribute(ATT_OBJECT_METACLASS);
                        IConfigurationElement[] propertyChildren = metaclassChildren[i2].getChildren(TAG_PROPERTY);
                        if (propertyChildren != null && propertyChildren.length > 0) {
                            int j = 0;
                            while (j < propertyChildren.length) {
                                PropertyRegistryReader.registerProperty(contribution, propertyChildren[j], metaclass);
                                ++j;
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static void registerProperty(Class contribution, IConfigurationElement element, String metaclass) {
        try {
            Object obj = element.createExecutableExtension("type");
            if (obj instanceof IPropertySet) {
                IPropertySet properties = (IPropertySet)obj;
                properties.setConfigurationElement(element);
                PropertyRegistryReader.addProperty(contribution, metaclass, properties);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void addProperty(Class contribution, String metaclass, IPropertySet property) {
        HashSet<IPropertySet> properties;
        if (metaclass == null) {
            metaclass = NO_METACLASS;
        }
        if (!myPropertySetCache.containsKey(property)) {
            myPropertySetCache.put(property, property);
        } else {
            property = (IPropertySet)myPropertySetCache.get(property);
        }
        HashMap<String, HashSet<IPropertySet>> metaclassMap = (HashMap<String, HashSet<IPropertySet>>)myRawObjectContributors.get(contribution);
        if (metaclassMap == null) {
            metaclassMap = new HashMap<String, HashSet<IPropertySet>>();
            myRawObjectContributors.put(contribution, metaclassMap);
        }
        if ((properties = (HashSet<IPropertySet>)metaclassMap.get(metaclass)) == null) {
            properties = new HashSet<IPropertySet>();
            metaclassMap.put(metaclass, properties);
        }
        properties.add(property);
    }

    private ArrayList getOriginalMetaclassMaps(Class objectClass) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        Iterator iter = myRawObjectContributors.keySet().iterator();
        while (iter.hasNext()) {
            HashMap oldMetaclassMap;
            Class clazz = (Class)iter.next();
            if (!clazz.isAssignableFrom(objectClass) || (oldMetaclassMap = (HashMap)myRawObjectContributors.get(clazz)) == null) continue;
            list.add(oldMetaclassMap);
        }
        return list;
    }

    private void addToMap(String metaclass, HashMap metaclassMap, HashMap oldMetaclassMap) {
        if (NO_METACLASS.equals(metaclass)) {
            HashSet properties = (HashSet)oldMetaclassMap.get(NO_METACLASS);
            this.addToList(metaclass, metaclassMap, properties);
        } else {
            Iterator oldIter = oldMetaclassMap.keySet().iterator();
            while (oldIter.hasNext()) {
                String metaclassTemplate = (String)oldIter.next();
                if (!this.isApplicable(metaclassTemplate, metaclass)) continue;
                HashSet properties = (HashSet)oldMetaclassMap.get(metaclassTemplate);
                this.addToList(metaclass, metaclassMap, properties);
            }
        }
    }

    private void addToList(String metaclass, HashMap metaclassMap, HashSet properties) {
        HashSet oldProperties = (HashSet)metaclassMap.get(metaclass);
        if (oldProperties == null) {
            if (properties == null) {
                metaclassMap.put(metaclass, NO_DESCRIPTORS);
            } else {
                metaclassMap.put(metaclass, properties.clone());
            }
        } else {
            oldProperties.addAll((HashSet)properties.clone());
        }
    }

    private void dumpMap(HashMap map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            HashMap mMap = (HashMap)map.get(iter.next());
            Iterator mIter = mMap.keySet().iterator();
            while (mIter.hasNext()) {
                Object obj = mIter.next();
                System.out.println(NO_METACLASS + obj);
                HashSet set = (HashSet)mMap.get(obj);
                this.dumpSet(set);
            }
        }
    }

    private void dumpSet(HashSet set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            System.out.println("\t\t\t" + iter.next());
        }
    }

    private boolean isApplicable(String metaclassTemplate, String metaclass) {
        if (metaclass == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(metaclassTemplate, ",");
        while (st.hasMoreTokens()) {
            if (!metaclass.equals(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    private IPropertySet[] getPropertSet(Object object, HashSet properties) {
        IPropertySet[] arPropertySet = new IPropertySet[]{};
        if (properties != null) {
            ArrayList<IPropertySet> list = new ArrayList<IPropertySet>();
            Iterator itr = properties.iterator();
            while (itr.hasNext()) {
                IPropertySet propertySet = (IPropertySet)itr.next();
                propertySet.setObjects(new Object[]{object});
                if (!propertySet.isApplicable()) continue;
                list.add(propertySet);
            }
            ArrayList newList = (ArrayList)list.clone();
            int i = 0;
            while (i < list.size() - 1) {
                int j = i + 1;
                while (j < list.size()) {
                    IPropertySet ps2;
                    IPropertySet ps1 = (IPropertySet)list.get(i);
                    if (ps1.equalsTo(ps2 = (IPropertySet)list.get(j))) {
                        Integer rank1 = ps1.getOverrideRank();
                        Integer rank2 = ps2.getOverrideRank();
                        if (rank1 != null && rank2 != null) {
                            if (rank1.compareTo(rank2) != 0) {
                                if (rank1.compareTo(rank2) > 0) {
                                    ((AbstractCollection)newList).remove(ps2);
                                } else {
                                    ((AbstractCollection)newList).remove(ps1);
                                }
                            }
                        } else if (rank1 != null && rank2 == null) {
                            ((AbstractCollection)newList).remove(ps2);
                        } else if (rank2 != null && rank1 == null) {
                            ((AbstractCollection)newList).remove(ps1);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            arPropertySet = new IPropertySet[newList.size()];
            newList.toArray(arPropertySet);
        }
        return arPropertySet;
    }

    private static class ReadRegistryThread
    extends Thread {
        private ReadRegistryThread() {
        }

        public void run() {
            Object object = FLAG;
            synchronized (object) {
                if (myObjectContributors == null) {
                    myObjectContributors = new HashMap();
                    myRawObjectContributors = new HashMap();
                    myPropertySetCache = new HashMap();
                    PropertyRegistryReader.readRegistry();
                }
            }
        }
    }
}

