/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.DefaultPropertSource;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.internal.model.ui.PropertyRegistryReader;
import com.tssap.selena.internal.model.ui.PropertySheetLayouter;
import com.tssap.selena.internal.model.ui.PropertySheetUpdater;
import com.tssap.selena.internal.model.ui.keyboardShortcuts.KeyboardNotifier;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.property.IPropertySet;
import com.tssap.selena.model.util.ModelUinSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ModelUIPlugin
extends AbstractUIPlugin {
    private boolean myFirstActivation = true;
    private static final boolean DEBUG = true;
    private static ModelUIPlugin ourPlugin;
    private static final String PROPERTY_EXTENSION_POINT = "property";

    public ModelUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourPlugin = this;
    }

    public void startup() throws CoreException {
        super.startup();
        PropertyRegistryReader.lazyReadRegistry();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            this.myFirstActivation = false;
            final Shell shell = workbenchWindow.getShell();
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellActivated(ShellEvent e) {
                    IWorkbenchPage page = ModelUIPlugin.getWorkbenchPage();
                    if (page != null) {
                        page.addSelectionListener((ISelectionListener)new PropertySheetUpdater());
                        page.addSelectionListener((ISelectionListener)new PropertySheetLayouter());
                        shell.removeShellListener((ShellListener)this);
                    }
                }
            });
        } else {
            workbench.addWindowListener(new IWindowListener(){
                private IWindowListener mySelf;

                public void windowActivated(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowOpened(IWorkbenchWindow window) {
                    if (ModelUIPlugin.this.myFirstActivation) {
                        this.mySelf = this;
                        ModelUIPlugin.this.myFirstActivation = false;
                        Shell shell = window.getShell();
                        shell.addShellListener((ShellListener)new ShellAdapter(this, shell){
                            private final /* synthetic */ Shell val$shell;
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$shell = val$shell;
                            }

                            public void shellActivated(ShellEvent e) {
                                IWorkbenchPage page = ModelUIPlugin.getWorkbenchPage();
                                if (page != null) {
                                    page.addSelectionListener((ISelectionListener)new PropertySheetUpdater());
                                    page.addSelectionListener((ISelectionListener)new PropertySheetLayouter());
                                    this.val$shell.removeShellListener((ShellListener)this);
                                    2.access$200(this.this$1).removeWindowListener(2.access$100(this.this$1));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ IWindowListener access$100(2 x0) {
                    return x0.mySelf;
                }

                static /* synthetic */ IWorkbench access$200(2 x0) {
                    return x0.workbench;
                }
            });
        }
    }

    static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            return page;
        }
        return null;
    }

    public static ModelUIPlugin getDefault() {
        return ourPlugin;
    }

    public void log(String line) {
        Status status = new Status(4, this.getDescriptor().getUniqueIdentifier(), 0, line, null);
        this.getLog().log((IStatus)status);
        System.out.println(line);
    }

    public KeyboardNotifier getKeyboardNotifier() {
        return KeyboardNotifier.getInstance();
    }

    public static String getPropertyExtensionPoint() {
        return PROPERTY_EXTENSION_POINT;
    }

    public static String getPluginID() {
        if (ourPlugin != null) {
            return ourPlugin.getDescriptor().getUniqueIdentifier();
        }
        return null;
    }

    public IPropertySet[] getProperties(Class objectClass, Object object) {
        return PropertyRegistryReader.getInstance().getProperties(objectClass, object);
    }

    public IPropertySource getPropertySource(Class objectClass, Object object) {
        return new DefaultPropertSource(objectClass, object);
    }

    public void openEditor(Element element, IWorkbenchPage page) {
        this.openEditor(element, page, true);
    }

    public void openEditor(Element element, IWorkbenchPage page, boolean forceOpening) {
        if (element.hasProperty("$design:entity_type")) {
            return;
        }
        IEditorPart editorPart = ModelUIPlugin.openInEditor(element, page, forceOpening);
        if (editorPart != null) {
            ModelUIPlugin.revealInEditor(editorPart, element);
        }
    }

    private static boolean isEditorOpened(IWorkbenchPage page, IFile file) {
        return page.isEditorAreaVisible() && page.findEditor((IEditorInput)new FileEditorInput(file)) != null;
    }

    private static IEditorPart openInEditor(Element element, IWorkbenchPage page, boolean forceOpening) {
        String sourceFile = element.getPropertyValue("$file");
        UniqueName modelUin = element.getModel().getUniqueName();
        String project = element.getPropertyValue("$original_project");
        if (project == null) {
            project = ModelUinSupport.getProjectId((UniqueName)modelUin);
        }
        if (project == null) {
            return null;
        }
        IFile file = ModelUIPlugin.getResourceForRelativePath(sourceFile, project);
        if (file == null) {
            return null;
        }
        if (page != null) {
            try {
                if (forceOpening || ModelUIPlugin.isEditorOpened(page, file)) {
                    IEditorPart existsPart = page.findEditor((IEditorInput)new FileEditorInput(file));
                    if (existsPart != null) {
                        page.bringToTop((IWorkbenchPart)existsPart);
                        return existsPart;
                    }
                    return page.openEditor(file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void revealInEditor(IEditorPart editorPart, Element element) {
        int endPosition;
        int startPosition;
        if (!(editorPart instanceof ITextEditor)) {
            return;
        }
        try {
            startPosition = Integer.parseInt(element.getPropertyValue("$startPosition"));
            endPosition = Integer.parseInt(element.getPropertyValue("$endPosition"));
        }
        catch (Exception cannotParseOrNull) {
            startPosition = -1;
            endPosition = -1;
        }
        if (startPosition == -1 || endPosition == -1) {
            return;
        }
        int length = endPosition - startPosition + 1;
        ((ITextEditor)editorPart).selectAndReveal(startPosition, length);
    }

    private static IFile getResourceForRelativePath(String fileName, String projectId) {
        if (fileName == null) {
            return null;
        }
        Path filePath = new Path(fileName);
        IResource fileResource = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId).findMember((IPath)filePath);
        if (fileResource == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId).getFile((IPath)filePath);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                try {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                    return file;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        if (fileResource.getType() != 1) {
            return null;
        }
        return (IFile)fileResource;
    }

    private static void asyncMenuLoad() {
        class FakeWrapper
        implements IElementWrapper,
        IActionFilter {
            FakeWrapper() {
            }

            public boolean testAttribute(Object target, String name, String value) {
                return false;
            }

            public String getUserProperty(String name) {
                return null;
            }

            public Entity getResolvedElement() {
                return null;
            }

            public Element getOriginalElement() {
                return null;
            }

            public String getViewID() {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        }
        StructuredSelection sel = new StructuredSelection((Object)new FakeWrapper());
        final ISelectionProvider sp = new ISelectionProvider((ISelection)sel){
            private final /* synthetic */ ISelection val$sel;
            {
                this.val$sel = val$sel;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.val$sel;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
        Thread d = new Thread("ElementWrapper menu contibutors async load"){

            public void run() {
                ObjectActionContributorManager.getManager().contributeObjectActions(null, (IMenuManager)new MenuManager(), sp);
            }
        };
        d.setPriority(1);
        d.start();
    }
}

