/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.DeleteHandlerElement;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.IDeleteHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;

public class DeleteHandlerRegistry {
    private static final String PT_DELETE_HANDLER = "deleteHandler";
    private static final String TAG_DELETE_HANDLER = "deleteHandler";
    private static final String ATT_ID = "id";
    private static final String ATT_METACLASS = "metaclass";
    private static final String ATT_CLASS = "class";
    private static List ourDeleteHandlers;

    private static List readDeletes() {
        IExtensionPoint point = ModelUIPlugin.getDefault().getDescriptor().getExtensionPoint("deleteHandler");
        IConfigurationElement[] elements = point.getConfigurationElements();
        ArrayList rv = new ArrayList(elements.length);
        int i = 0;
        while (i < elements.length) {
            if ("deleteHandler".equals(elements[i].getName())) {
                DeleteHandlerRegistry.readElement(rv, elements[i]);
            }
            ++i;
        }
        return rv;
    }

    private static void readElement(List allHandlers, IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        String metaclasses = element.getAttribute(ATT_METACLASS);
        try {
            IDeleteHandler handler = (IDeleteHandler)element.createExecutableExtension(ATT_CLASS);
            allHandlers.add(new DeleteHandlerElement(metaclasses, handler));
        }
        catch (CoreException e) {
            System.out.println("Can't instantiate: " + element);
        }
    }

    private static void initDeleteHandlers() {
        if (ourDeleteHandlers == null) {
            ourDeleteHandlers = DeleteHandlerRegistry.readDeletes();
        }
    }

    public static boolean canDelete(Element element) {
        boolean canDelete = true;
        DeleteHandlerRegistry.initDeleteHandlers();
        IDeleteHandler[] deleteHandlers = DeleteHandlerRegistry.getApplicableDeleteHandlers(element);
        int i = 0;
        while (canDelete && i < deleteHandlers.length) {
            if (!deleteHandlers[i].canDelete(element)) {
                canDelete = false;
            }
            ++i;
        }
        return canDelete;
    }

    private static IDeleteHandler[] getApplicableDeleteHandlers(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        if (metaclass != null) {
            return DeleteHandlerRegistry.getApplicableToMetaclass(metaclass);
        }
        return new IDeleteHandler[0];
    }

    private static IDeleteHandler[] getApplicableToMetaclass(String metaclass) {
        ArrayList<IDeleteHandler> rv = new ArrayList<IDeleteHandler>(3);
        Iterator it = ourDeleteHandlers.iterator();
        while (it.hasNext()) {
            DeleteHandlerElement el = (DeleteHandlerElement)it.next();
            if (!el.isApplicable(metaclass)) continue;
            rv.add(el.getHandler());
        }
        return rv.toArray(new IDeleteHandler[rv.size()]);
    }
}

