/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.model.ui.property.IPropertySet;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.internal.ChromePlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class DefaultPropertyDescriptor
implements IPropertyDescriptor {
    private IPropertySet myProperties;
    private Object myId;
    private Object myParameter;

    public DefaultPropertyDescriptor(IPropertySet properties, Object id, Object parameter) {
        this.myProperties = properties;
        this.myId = id;
        this.myParameter = parameter;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        String support;
        if (!this.myProperties.isReadonly(this.myId) && (support = this.myProperties.getSupport(this.myId)) != null) {
            IPropertySupport propertySupport = ChromePlugin.getInstance().getPropertySupport(support, new Object[]{this.myParameter});
            if (propertySupport != null) {
                CellEditor cellEditor = propertySupport.createPropertyEditor(parent);
                if (cellEditor != null) {
                    cellEditor.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            return DefaultPropertyDescriptor.this.myProperties.isValidValue(DefaultPropertyDescriptor.this.myId, value);
                        }
                    });
                }
                return cellEditor;
            }
            System.err.println("PropertySupport '" + support + "' not found.");
            return null;
        }
        return null;
    }

    public String getCategory() {
        return this.myProperties.getCategory(this.myId);
    }

    public String getDescription() {
        return this.myProperties.getDescription(this.myId);
    }

    public String getDisplayName() {
        return this.myProperties.getDisplayName(this.myId);
    }

    public String[] getFilterFlags() {
        return this.myProperties.getFilterFlags(this.myId);
    }

    public Object getHelpContextIds() {
        return this.myProperties.getHelpContextIds(this.myId);
    }

    public Object getId() {
        return this.myId;
    }

    public ILabelProvider getLabelProvider() {
        IPropertySupport propertySupport;
        String support = this.myProperties.getSupport(this.myId);
        if (support != null && (propertySupport = ChromePlugin.getInstance().getPropertySupport(support)) != null) {
            return propertySupport.getLabelProvider();
        }
        return new LabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        Object id2;
        Object id1 = this.getId();
        if (id1.equals(id2 = anotherProperty.getId())) {
            if (this.getCategory() == null) {
                return anotherProperty.getCategory() == null;
            }
            return this.getCategory().equals(anotherProperty.getCategory());
        }
        return false;
    }
}

