/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui;

import com.tssap.selena.internal.model.ui.DefaultPropertyDescriptor;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.ui.property.IPropertySet;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

class DefaultPropertSource
implements IPropertySource {
    private final HashMap myId2Properties;
    private final Object myObject;
    private final Class myObjectContributor;
    private int lock = 0;

    public DefaultPropertSource(Class objectContributor, Object object) {
        this.myObject = object;
        this.myObjectContributor = objectContributor;
        this.myId2Properties = new HashMap();
    }

    public Object getEditableValue() {
        return this.myObject;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.myObject == null || this.myObjectContributor == null) {
            return new IPropertyDescriptor[0];
        }
        IPropertySet[] allProperties = ModelUIPlugin.getDefault().getProperties(this.myObjectContributor, this.myObject);
        ArrayList<DefaultPropertyDescriptor> list = new ArrayList<DefaultPropertyDescriptor>();
        Object parameter = this.myObject;
        if (parameter instanceof Reference) {
            parameter = ((Reference)parameter).getEntity();
        }
        int i = 0;
        while (i < allProperties.length) {
            IPropertySet properties = allProperties[i];
            Object[] ids = properties.getIds();
            if (ids != null) {
                int j = 0;
                while (j < ids.length) {
                    this.myId2Properties.put(ids[j], properties);
                    list.add(new DefaultPropertyDescriptor(properties, ids[j], parameter));
                    ++j;
                }
            }
            ++i;
        }
        IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[list.size()];
        list.toArray(propertyDescriptors);
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        try {
            IPropertySet properties = (IPropertySet)this.myId2Properties.get(id);
            if (properties != null) {
                return properties.getValue(id);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ModelUIPlugin.getDefault().getLog().log((IStatus)new Status(2, ModelUIPlugin.getPluginID(), 0, "Updating property sheet - getPropertyValue failed:", (Throwable)ex));
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(final Object id, final Object value) {
        if (this.lock > 0) {
            return;
        }
        ++this.lock;
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                DefaultPropertSource.this.primSetPropertyValue(id, value);
            }
        });
        --this.lock;
    }

    private void primSetPropertyValue(Object id, Object value) {
        try {
            IPropertySet properties = (IPropertySet)this.myId2Properties.get(id);
            if (properties != null) {
                properties.setValue(id, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ModelUIPlugin.getDefault().getLog().log((IStatus)new Status(2, ModelUIPlugin.getPluginID(), 0, "Updating property sheet - sePropertyValue failed:", (Throwable)ex));
        }
    }
}

