/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlSinglePartElement;
import com.sapportals.portal.prt.util.html.IHtmlUniqueObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlLink
extends HtmlSinglePartElement
implements IHtmlUniqueObject {
    protected String m_rel;
    protected String m_hRef;
    protected String m_type;

    public HtmlLink(String href) {
        this.setTag("link");
        if (href == null) {
            throw new Error("[HtmlLink.HtmlLink] The HREF is not given for the link.");
        }
        this.m_hRef = href;
    }

    public HtmlLink() {
        this.setTag("link");
    }

    public void outputAttributes(StringBuffer strbuf) {
        if (this.m_rel != null) {
            strbuf.append(" REL=").append(this.m_rel).append(" ");
        }
        if (this.m_hRef != null) {
            strbuf.append(" HREF=\"").append(this.m_hRef).append("\" ");
        }
        if (this.m_type != null) {
            strbuf.append(" TYPE=\"").append(this.m_type).append("\" ");
        }
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        try {
            if (this.m_rel != null) {
                out.write(" REL=");
                out.write(this.m_rel);
                out.write(" ");
            }
            if (this.m_hRef != null) {
                out.write(" HREF=\"");
                out.write(this.m_hRef);
                out.write("\" ");
            }
            if (this.m_type != null) {
                out.write(" TYPE=\"");
                out.write(this.m_type);
                out.write("\" ");
            }
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public String getUniqueId() {
        return this.m_hRef;
    }

    public void getUniqueHtmlCode(StringBuffer strbuf) {
        this.output(strbuf);
    }

    public void getUniqueHtmlCode(PrintWriter out) {
        this.output((Writer)out);
    }

    public void getUniqueHtmlCode(Writer out) {
        this.output(out);
    }

    public String getRel() {
        return this.m_rel;
    }

    public HtmlLink setRel(String v) {
        this.m_rel = v;
        return this;
    }

    public String getHRef() {
        return this.m_hRef;
    }

    public HtmlLink setHRef(String v) {
        this.m_hRef = v;
        return this;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String v) {
        this.m_type = v;
    }
}

