/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlBase;
import com.sapportals.portal.prt.util.html.HtmlString;
import com.sapportals.portal.prt.util.html.IHtmlOutputable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlContainer
extends HtmlBase {
    protected Vector m_htmlElements;

    public HtmlContainer() {
        this.requireClosingTag(true);
        this.m_htmlElements = new Vector(10);
    }

    public void output(StringBuffer strbuf) {
        this.outputStartTag(strbuf);
        this.outputChildren(strbuf);
        this.outputEndTag(strbuf);
    }

    public void output(PrintWriter writer) {
        this.output((Writer)writer);
    }

    public void output(Writer writer) {
        this.outputStartTag(writer);
        this.outputChildren(writer);
        this.outputEndTag(writer);
    }

    public final String toString() {
        StringWriter out = new StringWriter(200);
        this.output(out);
        return out.toString();
    }

    protected void outputChildren(StringBuffer strbuf) {
        int size = this.m_htmlElements.size();
        int i = 0;
        while (i < size) {
            IHtmlOutputable hc = (IHtmlOutputable)this.m_htmlElements.elementAt(i);
            hc.output(strbuf);
            ++i;
        }
    }

    protected void outputStartTag(StringBuffer strbuf) {
        if (this.hasTag()) {
            strbuf.append("<");
            strbuf.append(this.getTag()).append(" ");
            this.outputAttributes(strbuf);
            strbuf.append(" >");
        }
    }

    protected void outputEndTag(StringBuffer strbuf) {
        if (this.hasTag() && this.requireClosingTag()) {
            strbuf.append("</");
            strbuf.append(this.getTag());
            strbuf.append(">");
        }
    }

    protected void outputChildren(Writer writer) {
        int size = this.m_htmlElements.size();
        int i = 0;
        while (i < size) {
            IHtmlOutputable hc = (IHtmlOutputable)this.m_htmlElements.elementAt(i);
            hc.output(writer);
            ++i;
        }
    }

    protected void outputStartTag(Writer writer) {
        if (this.hasTag()) {
            try {
                writer.write("<");
                writer.write(this.getTag());
                this.outputAttributes(writer);
                writer.write(">");
            }
            catch (IOException e) {
                throw new PortalRuntimeException(e);
            }
        }
    }

    protected void outputEndTag(Writer writer) {
        if (this.hasTag() && this.requireClosingTag()) {
            try {
                writer.write("</");
                writer.write(this.getTag());
                writer.write(">");
            }
            catch (IOException e) {
                throw new PortalRuntimeException(e);
            }
        }
    }

    public int getElementCount() {
        int count = 0;
        Vector elems = this.getHtmlElements();
        int len = elems.size();
        int i = 0;
        while (i < len) {
            IHtmlOutputable hc = (IHtmlOutputable)elems.elementAt(i);
            count += hc.getElementCount();
            ++count;
            ++i;
        }
        return count;
    }

    public Vector getHtmlElements() {
        return this.m_htmlElements;
    }

    public void setHtmlElements(Vector v) {
        this.m_htmlElements = v;
    }

    public HtmlContainer addElement(IHtmlOutputable element) {
        if (element == null) {
            return this;
        }
        this.m_htmlElements.addElement(element);
        return this;
    }

    public HtmlContainer addElement(String aString) {
        if (aString == null) {
            return this;
        }
        this.m_htmlElements.addElement(new HtmlString(aString));
        return this;
    }

    public void removeElement(IHtmlOutputable element) {
        this.m_htmlElements.removeElement(element);
    }

    public void removeAllElements() {
        this.m_htmlElements.removeAllElements();
    }

    public void destroy() {
        Enumeration enumeration = this.m_htmlElements.elements();
        while (enumeration.hasMoreElements()) {
            IHtmlOutputable item = (IHtmlOutputable)enumeration.nextElement();
            item.destroy();
        }
        this.removeAllElements();
        this.m_htmlElements = null;
    }
}

