/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.util.html.IHtmlAttributeContainer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class HtmlAttributeContainer
implements IHtmlAttributeContainer {
    protected static final String SPACE = " ";
    protected static final String EQUALS_BEGIN = "=\"";
    protected static final String EQUALS_END = "\"";
    protected Hashtable m_attributes = new Hashtable(10);

    protected HtmlAttributeContainer() {
    }

    public void outputAttributes(StringBuffer strbuf) {
        Hashtable attr = this.getAttributes();
        Enumeration e = attr.keys();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            String value = (String)attr.get(prop);
            strbuf.append(SPACE).append(prop).append(EQUALS_BEGIN).append(value).append(EQUALS_END);
        }
    }

    public void outputAttributes(PrintWriter writer) {
        this.outputAttributes((Writer)writer);
    }

    public void outputAttributes(Writer writer) {
        try {
            Hashtable attr = this.getAttributes();
            Enumeration e = attr.keys();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                String value = (String)attr.get(prop);
                writer.write(SPACE);
                writer.write(prop);
                writer.write(EQUALS_BEGIN);
                writer.write(value);
                writer.write(EQUALS_END);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public IHtmlAttributeContainer appendToAttribute(String propName, String value) {
        if (propName == null) {
            throw new Error("[HtmlContainer.addProperty] Cannot add a NULL property");
        }
        String oldvalue = (String)this.m_attributes.get(propName);
        if (oldvalue == null) {
            this.addAttribute(propName, value);
        } else {
            this.addAttribute(propName, new StringBuffer(30).append(oldvalue).append(value).toString());
        }
        return this;
    }

    public IHtmlAttributeContainer addAttribute(String propName, String value) {
        if (propName == null) {
            throw new Error("[HtmlAttributeContainer.addProperty] Cannot add a NULL property");
        }
        this.m_attributes.put(propName, value);
        return this;
    }

    public IHtmlAttributeContainer removeAttribute(String propName) {
        this.m_attributes.remove(propName);
        return this;
    }

    public void destroy() {
        this.m_attributes.clear();
        this.m_attributes = null;
    }

    public abstract int getElementCount();

    public abstract void output(Writer var1);

    public abstract void output(PrintWriter var1);

    public abstract void output(StringBuffer var1);

    public abstract boolean requireClosingTag();

    public abstract void requireClosingTag(boolean var1);

    public abstract void setTag(String var1);

    public abstract String getTag();
}

