/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlContainerIdentifiableWithUniqueManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class HtmlApplet
extends HtmlContainerIdentifiableWithUniqueManager {
    private String m_code;
    private String m_codebase;
    private String m_name;
    private String m_id;
    private String m_archive;
    private Hashtable m_param;
    private boolean m_mayScript;

    public HtmlApplet() {
        this.setTag("applet");
        this.m_mayScript = false;
    }

    public void outputAttributes(StringBuffer strbuf) {
        super.outputAttributes(strbuf);
        if (this.m_code != null) {
            strbuf.append(new String("  CODE=\"") + this.m_code + "\"\n");
        }
        if (this.m_codebase != null) {
            strbuf.append(new String("  CODEBASE=\"") + this.m_codebase + "\"");
        }
        if (this.m_name != null) {
            strbuf.append(new String("  NAME=\"") + this.m_name + "\"\n");
        }
        if (this.m_id != null) {
            strbuf.append(new String("  ID=\"") + this.m_id + "\"\n");
        }
        if (this.m_archive != null) {
            strbuf.append(new String("  ARCHIVE=\"") + this.m_archive + "\"\n");
        }
        if (this.m_mayScript) {
            strbuf.append("    MAYSCRIPT ");
        }
        if (this.m_param != null) {
            Enumeration e = this.m_param.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.m_param.get(name);
                strbuf.append("   >\n <PARAM name=" + name + " value=\"" + value + "\"");
            }
        }
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        super.outputAttributes(out);
        try {
            if (this.m_code != null) {
                out.write(" CODE=\"");
                out.write(this.m_code);
                out.write("\"\n");
            }
            if (this.m_codebase != null) {
                out.write(" CODEBASE=\"");
                out.write(this.m_codebase);
                out.write("\"");
            }
            if (this.m_name != null) {
                out.write(" NAME=\"");
                out.write(this.m_name);
                out.write("\"\n");
            }
            if (this.m_id != null) {
                out.write(" ID=\"");
                out.write(this.m_id);
                out.write("\"\n");
            }
            if (this.m_archive != null) {
                out.write(" ARCHIVE=\"");
                out.write(this.m_archive);
                out.write("\"\n");
            }
            if (this.m_mayScript) {
                out.write("    MAYSCRIPT ");
            }
            if (this.m_param != null) {
                Enumeration e = this.m_param.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String value = (String)this.m_param.get(name);
                    out.write("   >\n <PARAM name=");
                    out.write(name);
                    out.write(" value=\"");
                    out.write(value);
                    out.write("\"");
                }
            }
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public HtmlApplet setName(String name) {
        this.m_name = name;
        return this;
    }

    public HtmlApplet setCodebase(String codebase) {
        this.m_codebase = codebase;
        return this;
    }

    public HtmlApplet setScript() {
        this.m_mayScript = true;
        return this;
    }

    public HtmlApplet setArchive(String archive) {
        this.m_archive = archive;
        return this;
    }

    public HtmlApplet setCode(String code) {
        this.m_code = code;
        return this;
    }

    public HtmlApplet addParam(String name, String value) {
        if (this.m_param == null) {
            this.m_param = new Hashtable(10);
        }
        this.m_param.put(name, value);
        return this;
    }
}

