/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.util.SharedString;
import com.sapportals.portal.prt.util.SmartBuffer;
import com.sapportals.portal.prt.util.StringBufferPool;

public class RecyclableStringBuffer {
    private int mm_nbSharedString = 0;
    boolean m_isReleasable = false;
    StringBufferPool mm_pool;
    private SmartBuffer mm_strBuf;

    public RecyclableStringBuffer() {
        this.mm_strBuf = new SmartBuffer();
        this.m_isReleasable = false;
    }

    public RecyclableStringBuffer(int size) {
        this.mm_strBuf = new SmartBuffer(size);
        this.m_isReleasable = false;
    }

    public RecyclableStringBuffer(StringBufferPool pool) {
        this();
        this.mm_pool = pool;
        this.m_isReleasable = false;
    }

    public void reset() {
        this.mm_strBuf.reset();
    }

    public void realloc(int size) {
        this.mm_strBuf.reset();
        this.mm_strBuf.ensureCapacity(size);
    }

    public SmartBuffer getBuffer() {
        return this.mm_strBuf;
    }

    public String toString() {
        return this.mm_strBuf.toString();
    }

    public SharedString getSharedString() {
        this.mm_strBuf.m_shared = true;
        this.m_isReleasable = false;
        ++this.mm_nbSharedString;
        return new SharedString(this);
    }

    void releaseSharedString() {
        --this.mm_nbSharedString;
        if (this.mm_nbSharedString <= 0) {
            this.getBuffer().m_shared = false;
        }
        if (this.mm_nbSharedString == 0 && this.m_isReleasable) {
            this.mm_pool.release(this);
        }
    }

    void release() {
        this.m_isReleasable = true;
    }

    boolean isReleasable() {
        return this.mm_nbSharedString == 0 && this.m_isReleasable || !this.mm_strBuf.m_shared && this.m_isReleasable;
    }
}

