/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.util.MultiValuedHashMap;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;

public class AbstractURI {
    private String mm_scheme = null;
    private String mm_fragment = null;
    private String mm_userInfo = null;
    private String mm_host = null;
    private String mm_port = null;
    private String mm_path = null;
    private MultiValuedHashMap mm_parameters = new MultiValuedHashMap(1);

    private void clear() {
        this.setScheme(null);
        this.setFragment(null);
        this.setUserInfo(null);
        this.setHost(null);
        this.setPort(null);
        this.setPath(null);
        this.removeParameters();
    }

    public AbstractURI() {
    }

    public AbstractURI(String uri) {
        this();
        this.setURI(uri);
    }

    public void setURI(String uri) {
        this.parse(uri);
    }

    protected void parse(String uri) {
        this.clear();
        if (uri != null) {
            int b = uri.indexOf(58);
            if (b >= 0) {
                this.setScheme(uri.substring(0, b));
            }
            ++b;
            int e = uri.lastIndexOf(35);
            if (e >= 0) {
                this.setFragment(uri.substring(e + 1));
            } else {
                e = uri.length();
            }
            int bp = -1;
            if (b < e - 1 && uri.charAt(b) == '/' && uri.charAt(b + 1) == '/') {
                bp = uri.indexOf(47, b += 2);
                if (bp < 0 && (bp = uri.indexOf(63, b)) < 0) {
                    bp = e;
                }
                if (bp > b && bp <= e) {
                    int eu = uri.indexOf(64, b);
                    if (eu > b && eu < bp) {
                        this.setUserInfo(uri.substring(b, eu));
                        b = eu + 1;
                    }
                    if ((eu = uri.indexOf(58, b)) > b && eu < bp) {
                        this.setHost(uri.substring(b, eu));
                        this.setPort(uri.substring(eu + 1, bp));
                    } else {
                        this.setHost(uri.substring(b, bp));
                    }
                }
            } else {
                bp = b;
            }
            if (bp >= 0 && bp < e) {
                int ep = uri.indexOf(63);
                if (ep < 0 || ep >= e) {
                    ep = e;
                } else {
                    StringTokenizer params = new StringTokenizer(uri.substring(ep + 1, e), "&");
                    if (params != null) {
                        while (params.hasMoreTokens()) {
                            String value;
                            String name;
                            String nameValue = params.nextToken();
                            int eq = nameValue.indexOf(61);
                            if (eq < 0) {
                                name = nameValue;
                                value = null;
                                this.addParameter(URLDecoder.decode(name), null);
                                continue;
                            }
                            name = nameValue.substring(0, eq);
                            value = nameValue.substring(eq + 1);
                            this.addParameter(URLDecoder.decode(name), URLDecoder.decode(value));
                        }
                    }
                }
                if (bp < ep) {
                    this.setPath(uri.substring(bp, ep));
                }
            }
        }
    }

    public void setScheme(String scheme) {
        this.mm_scheme = scheme;
    }

    public String getScheme() {
        return this.mm_scheme;
    }

    public boolean isAbsolute() {
        return this.getScheme() != null;
    }

    public void setFragment(String fragment) {
        this.mm_fragment = fragment;
    }

    public String getFragment() {
        return this.mm_fragment;
    }

    public void setUserInfo(String userInfo) {
        this.mm_userInfo = userInfo;
    }

    public String getUserInfo() {
        return this.mm_userInfo;
    }

    public void setHost(String host) {
        this.mm_host = host;
    }

    public String getHost() {
        return this.mm_host;
    }

    public void setPort(String port) {
        this.mm_port = port;
    }

    public String getPort() {
        return this.mm_port;
    }

    public void setPath(String path) {
        this.mm_path = path;
    }

    public String getPath() {
        return this.mm_path;
    }

    public void removeParameters() {
        this.mm_parameters.clear();
    }

    public void removeParameter(String name) {
        this.mm_parameters.remove(name);
    }

    public void removeParameter(String name, String value) {
        this.mm_parameters.remove(name, value);
    }

    public void addParameter(String name, String value) {
        this.mm_parameters.put(name, value);
    }

    public String[] getParameterValues(String name) {
        MultiValuedHashMap multiValuedHashMap = this.mm_parameters;
        synchronized (multiValuedHashMap) {
            Object[] a = new String[this.mm_parameters.size()];
            this.mm_parameters.getValues(name, a);
            Object[] objectArray = a;
            return objectArray;
        }
    }

    public String getParameterValue(String name) {
        return (String)this.mm_parameters.getValue(name);
    }

    public Iterator getParameterValuesIterator(String name) {
        return this.mm_parameters.getValuesIterator(name);
    }

    public Enumeration getParametersEnumeration() {
        return this.mm_parameters.getKeysEnumeration();
    }

    public String[] getParameters() {
        MultiValuedHashMap multiValuedHashMap = this.mm_parameters;
        synchronized (multiValuedHashMap) {
            Object[] a = new String[this.mm_parameters.size()];
            this.mm_parameters.getKeys(a);
            Object[] objectArray = a;
            return objectArray;
        }
    }

    public String getQuery() {
        AbstractURI abstractURI = this;
        synchronized (abstractURI) {
            Enumeration enumeration = this.getParametersEnumeration();
            if (enumeration != null && enumeration.hasMoreElements()) {
                StringBuffer result = new StringBuffer();
                boolean first = true;
                while (enumeration.hasMoreElements()) {
                    String name = URLEncoder.encode((String)enumeration.nextElement());
                    Iterator vi = this.getParameterValuesIterator(name);
                    while (vi.hasNext()) {
                        String value = (String)vi.next();
                        if (value == null) continue;
                        if (!first) {
                            result.append("&");
                        }
                        first = false;
                        result.append(name + "=" + URLEncoder.encode(value));
                    }
                }
                String string = result.toString();
                return string;
            }
        }
        return null;
    }

    public String toString() {
        String fragment;
        String query;
        String path;
        StringBuffer result = new StringBuffer();
        String scheme = this.getScheme();
        if (scheme != null) {
            String port;
            String host;
            result.append(scheme + "://");
            String ui = this.getUserInfo();
            if (ui != null) {
                result.append(ui + "@");
            }
            if ((host = this.getHost()) != null) {
                result.append(host);
            }
            if ((port = this.getPort()) != null) {
                result.append(":" + port);
            }
        }
        if ((path = this.getPath()) != null) {
            result.append(path);
        }
        if ((query = this.getQuery()) != null) {
            result.append("?" + query);
        }
        if ((fragment = this.getFragment()) != null) {
            result.append("#" + fragment);
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }
}

