/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.component;

import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.runtime.PortalRuntimeException;

public class PortalComponentException
extends PortalRuntimeException {
    private String mm_componentName = null;
    private String mm_componentClass = null;
    private String mm_userName = null;

    public PortalComponentException(String s) {
        super(s);
    }

    public PortalComponentException(Throwable exception) {
        super("PortalComponentException", exception);
    }

    public PortalComponentException(String s, Throwable exception) {
        super(s, exception);
    }

    public void setDetail(IPortalComponentRequest request) {
        try {
            this.mm_userName = request.getUser().getLogonUid();
            this.mm_componentName = request.getComponentContext().getContextName();
            this.mm_componentClass = request.getNode().getComponent().getClass().getName();
        }
        catch (Exception e) {
            PortalRuntime.getLogger().warning(e, "Exception in method setDetail() of component: " + this.mm_componentName);
        }
    }

    public void setDetail(String userName, String componentName, String componentClass) {
        try {
            if (userName != null) {
                this.mm_userName = userName;
            }
            if (componentName != null) {
                this.mm_componentName = componentName;
            }
            if (componentClass != null) {
                this.mm_componentClass = componentClass;
            }
        }
        catch (Exception e) {
            PortalRuntime.getLogger().warning(e, "Exception in method setDetail() of component: " + this.mm_componentName);
        }
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.mm_componentName != null) {
            message = message + "\r\nComponent : " + this.mm_componentName;
        }
        if (this.mm_componentClass != null) {
            message = message + "\r\nComponent class : " + this.mm_componentClass;
        }
        if (this.mm_userName != null) {
            message = message + "\r\nUser : " + this.mm_userName;
        }
        return message;
    }
}

