/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.component;

import com.sapportals.portal.prt.util.Stringable;

public class ClientType
extends Stringable {
    public static final ClientType HTML = new ClientType("HTML");
    public static final ClientType WML = new ClientType("WML");
    public static final ClientType XML = new ClientType("XML");
    public static final ClientType TEXT = new ClientType("TEXT");
    public static final ClientType URL = new ClientType("URL");
    private static final String[] TypeAbbreviation = new String[]{"xy", "ie", "nn", "op", "xy", "xy", "xy", "xy", "xy"};
    public static final String[] TypeString = new String[]{"OTHER", "MSIE", "Mozilla", "Opera", "Nokia", "UP", "Ericsson", "MSPIE", "Palm"};
    public static final int OTHER = 0;
    public static final int MSIE = 1;
    public static final int NETSCAPE = 2;
    public static final int MOZILLA = 2;
    public static final int OPERA = 3;
    public static final int NOKIA = 4;
    public static final int UP = 5;
    public static final int ERICSSON = 6;
    public static final int MSPIE = 7;
    public static final int PALM = 8;
    public static final String[] PlatformString = new String[]{"OTHER", "Windows NT", "Win", "Mac", "Linux", "WAP", "PDA"};
    public static final int OTHER_PLATFORM = 0;
    public static final int NT_PLATFORM = 1;
    public static final int WIN_PLATFORM = 2;
    public static final int MAC_PLATFORM = 3;
    public static final int LINUX_PLATFORM = 4;
    public static final int WAP_PLATFORM = 5;
    public static final int PDA_PLATFORM = 6;
    private int m_browserType;
    private float m_version;
    private String m_fullVersion;
    private int m_platform;
    private String m_userAgent;

    public ClientType(String type) {
        super(type);
        this.m_browserType = 0;
        this.m_version = 0.0f;
        this.m_fullVersion = "0.0";
        this.m_platform = 0;
        this.m_userAgent = "";
    }

    /*
     * WARNING - void declaration
     */
    public ClientType(String type, String userAgent) {
        super(type);
        if (userAgent == null) {
            userAgent = "undefine";
        }
        this.m_userAgent = userAgent;
        int i = userAgent.indexOf(TypeString[1]);
        if (i != -1) {
            char ch;
            this.m_browserType = 1;
            i += TypeString[1].length();
            while (userAgent.charAt(++i) == ' ') {
            }
            this.m_fullVersion = userAgent.substring(i, userAgent.indexOf(59, i));
            int j = i;
            while ((ch = userAgent.charAt(j)) != ';') {
                void var5_7;
                if (!Character.isDigit((char)var5_7) && var5_7 != 46) break;
                ++j;
            }
            this.m_version = Float.parseFloat(userAgent.substring(i, j));
            this.m_platform = this.determinePlatform(userAgent, j);
        } else if (userAgent.indexOf("Safari") != -1) {
            this.m_browserType = 1;
            this.m_version = 6.0f;
            this.m_platform = 3;
        } else {
            i = userAgent.indexOf(TypeString[2]);
            if (i != -1 && userAgent.indexOf("AvantGo") == -1 && userAgent.indexOf("Mozilla/1.0") == -1) {
                char ch;
                this.m_browserType = 2;
                this.m_fullVersion = userAgent.substring(i += TypeString[2].length() + 1, userAgent.indexOf(32, i));
                int j = i;
                while ((ch = userAgent.charAt(j)) != ' ') {
                    if (!Character.isDigit(ch) && ch != '.') break;
                    ++j;
                }
                this.m_version = Float.parseFloat(userAgent.substring(i, j));
                this.m_platform = this.determinePlatform(userAgent, j);
            } else {
                i = userAgent.indexOf(TypeString[3]);
                if (i != -1) {
                    char ch;
                    this.m_browserType = 3;
                    this.m_fullVersion = userAgent.substring(i += TypeString[3].length() + 1, userAgent.indexOf(32, i));
                    int j = i;
                    while ((ch = userAgent.charAt(j)) != ' ') {
                        if (!Character.isDigit(ch) && ch != '.') break;
                        ++j;
                    }
                    this.m_version = Float.parseFloat(userAgent.substring(i, j));
                    this.m_platform = this.determinePlatform(userAgent, j);
                } else if (userAgent.indexOf("Nokia") != -1) {
                    this.m_browserType = 4;
                    this.m_platform = 5;
                    this.m_fullVersion = "0.4";
                    this.m_version = 0.4f;
                } else if (userAgent.indexOf("UP.") != -1 || userAgent.indexOf("UP/") != -1) {
                    this.m_browserType = 5;
                    this.m_platform = 5;
                    this.m_fullVersion = "4.1";
                    this.m_version = 4.1f;
                } else if (userAgent.indexOf("R380") != -1 || userAgent.indexOf("R320") != -1) {
                    this.m_browserType = 6;
                    this.m_platform = 5;
                    this.m_fullVersion = "1.0";
                    this.m_version = 1.0f;
                } else if (userAgent.indexOf("MSPIE") != -1 || userAgent.indexOf("CE") != -1) {
                    this.m_browserType = 7;
                    this.m_platform = 6;
                    this.m_fullVersion = "3.0";
                    this.m_version = 3.0f;
                } else if (userAgent.indexOf("AvantGo 3.2") != -1 || userAgent.indexOf("Mozilla/1.0") != -1) {
                    this.m_browserType = 8;
                    this.m_platform = 6;
                    this.m_fullVersion = "3.2";
                    this.m_version = 3.2f;
                } else {
                    this.m_browserType = 0;
                    this.m_fullVersion = "0.0";
                    this.m_version = 0.0f;
                    this.m_platform = 0;
                }
            }
        }
    }

    public String getAbbriviation() {
        return TypeAbbreviation[this.getBrowserType()] + this.getMajorVersion();
    }

    public int getBrowserType() {
        return this.m_browserType;
    }

    public String getBrowserTypeStr() {
        return TypeString[this.m_browserType];
    }

    public float getVersion() {
        return this.m_version;
    }

    public String getVersionStr() {
        return this.m_fullVersion;
    }

    public int getMajorVersion() {
        return (short)this.m_version;
    }

    public int getMinorVersion() {
        String myVersion = String.valueOf(this.m_version);
        int len = myVersion.length();
        int i = myVersion.indexOf(46);
        if (i != -1 && len > i) {
            return Integer.parseInt(myVersion.substring(i + 1, len));
        }
        return 0;
    }

    public int getPlatform() {
        return this.m_platform;
    }

    public String getPlatformStr() {
        return PlatformString[this.m_platform];
    }

    public String browserFamily() {
        return TypeString[this.m_browserType] + "/" + this.m_fullVersion + "/" + PlatformString[this.m_platform];
    }

    public String getHttpUserAgent() {
        return this.m_userAgent;
    }

    private int determinePlatform(String userAgent, int index) {
        int i = 0;
        while (i < PlatformString.length) {
            if (userAgent.indexOf(PlatformString[i], index) != -1) break;
            ++i;
        }
        return i;
    }

    public String printContent() {
        return "\n***** UserAgent *****\n" + super.toString() + ("\nBrowser Type Str:\t" + TypeString[this.m_browserType]) + ("\nBrowser Type:\t" + this.m_browserType) + ("\nVersion     :\t" + this.m_version) + ("\nVersion Str :\t" + this.m_fullVersion) + ("\nMajorVersion:\t" + this.getMajorVersion()) + ("\nMinorVersion:\t" + this.getMinorVersion()) + ("\nplatform    :\t" + this.m_platform) + ("\nplatform Str:\t" + PlatformString[this.m_platform]) + ("\nfamily      :\t" + this.browserFamily()) + ("\nUser Agent  :\t" + this.m_userAgent);
    }
}

