/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.javadoc;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavaDocInfo {
    private Document ivDocument;

    public JavaDocInfo(File srcFile) throws Exception {
        this.readFile(srcFile);
    }

    private void readFile(File srcFile) throws IOException, SAXException, ParserConfigurationException {
        ClassLoader oldLoader = null;
        try {
            oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = fact.newDocumentBuilder();
            this.ivDocument = docBuilder.parse(srcFile);
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public String getWindowTitle() {
        return this.getNodeValue("windowtitle");
    }

    public String getAccess() {
        String access = this.getNodeValue("access");
        if (!(access == null || "public".equals(access) || "protected".equals(access) || "package".equals(access) || "private".equals(access))) {
            access = null;
        }
        return access;
    }

    public String getDocTitle() {
        return this.getNodeValue("doctitle");
    }

    public String getHeader() {
        return this.getNodeValue("header");
    }

    public String getFooter() {
        return this.getNodeValue("footer");
    }

    public String getBottom() {
        return this.getNodeValue("bottom");
    }

    public String getOverview() {
        return this.getNodeValue("overview");
    }

    public Boolean isSplitIndex() {
        return this.getNodeBoolean("splitindex");
    }

    public Boolean isAuthor() {
        return this.getNodeBoolean("author");
    }

    public Boolean isVersion() {
        return this.getNodeBoolean("version");
    }

    private Boolean getNodeBoolean(String elementName) {
        String nodeValue = this.getNodeValue(elementName);
        if (nodeValue != null) {
            if ("true".equalsIgnoreCase(nodeValue) || "on".equalsIgnoreCase(nodeValue) || "yes".equalsIgnoreCase(nodeValue) || "1".equalsIgnoreCase(nodeValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private String getNodeValue(String elementName) {
        Node node;
        if (this.ivDocument == null) {
            return null;
        }
        NodeList byNameList = this.ivDocument.getElementsByTagName(elementName);
        if (byNameList.getLength() > 0 && (node = byNameList.item(0)) != null) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node aNode = childNodes.item(i);
                switch (aNode.getNodeType()) {
                    case 3: 
                    case 4: {
                        String txtValue = aNode.getNodeValue();
                        if (txtValue != null && (txtValue = txtValue.trim()).length() == 0) {
                            txtValue = null;
                        }
                        return txtValue;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

