/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.servicecontroller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.mapping.WizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.servicecontroller.ModelContextListBarViewer;
import com.sap.ide.webdynpro.template.simplescenario.servicecontroller.ModelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModelSelectionPage
extends ControllerWizardPage {
    private static final String TITLE;
    private static final String PAGE_NAME;
    private Text mNameField;
    private ModelContextListBarViewer mListBarViewer;
    private ContextWizardData mData;
    private ModelData modelData;
    private WizardData wData;
    private boolean mFirstTime = true;
    private boolean userDefined;

    public ModelSelectionPage(ContextWizardData data, ITemplateData tempData) {
        super(PAGE_NAME);
        this.setTitle(TITLE);
        this.setDescription(TextPool.getInstance().getText(2506));
        this.mData = data;
        this.modelData = (ModelData)tempData;
        this.setPageComplete(false);
    }

    public ModelSelectionPage(ContextWizardData data, WizardData wData, ITemplateData tempData) {
        this(data, tempData);
        this.wData = wData;
    }

    public boolean canFlipToNextPage() {
        ISelection selection = this.mListBarViewer.getSelection();
        return super.canFlipToNextPage() && selection != null && !selection.isEmpty();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.setControl((Control)root);
        this.addNameComponent(root);
        this.mListBarViewer = new ModelContextListBarViewer(this.mData.getModels());
        this.mListBarViewer.init(root);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        data.widthHint = 250;
        this.mListBarViewer.getControl().setLayoutData((Object)data);
        this.mListBarViewer.addSelectionChangedListener(new ContextSelectionChangeListener());
        String name = this.getValidControllerName("CustomController");
        this.mNameField.setText(name);
        this.modelData.setCustomControllerName(name);
        this.mNameField.setFocus();
        this.userDefined = false;
    }

    private void addNameComponent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData lCompositeData = new GridData(768);
        composite.setLayoutData((Object)lCompositeData);
        Label label = new Label(composite, 0);
        label.setText("Custom Controller   ");
        this.mNameField = new Text(composite, 2048);
        GridData gData = new GridData(768);
        this.mNameField.setLayoutData((Object)gData);
        this.mNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = ModelSelectionPage.this.mNameField.getText();
                ModelSelectionPage.this.userDefined = true;
                String errMsg = ModelSelectionPage.this.validateName(name);
                if (errMsg == null) {
                    ModelSelectionPage.this.modelData.setCustomControllerName(name);
                }
                ModelSelectionPage.this.setErrorMessage(errMsg);
                ModelSelectionPage.this.setPageComplete(errMsg == null);
            }
        });
    }

    private String getValidControllerName(String modelName) {
        String name = null;
        name = modelName;
        int counter = 0;
        while (this.validateName(name) != null) {
            name = modelName + counter++;
        }
        return name;
    }

    private String validateName(String name) {
        Component component;
        Controller[] controllers;
        if (name == null || name.equals("")) {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return CoreTextPool.getInstance().getText(17, (Object)name);
        }
        DevelopmentObject developmentObject = this.modelData.getContainingObject();
        if (developmentObject instanceof Component && (controllers = (component = (Component)developmentObject).getControllers()) != null) {
            int i = 0;
            while (i < controllers.length) {
                if (controllers[i].getName().equalsIgnoreCase(name)) {
                    return "Name already exists";
                }
                ++i;
            }
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        this.modelData.setValid(complete);
        super.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        if (!this.modelData.hasUsedModels()) {
            this.modelData.setValid(false);
            this.setErrorMessage("No Used Models. Add Models to the component for data binding");
            this.setPageComplete(false);
        } else if (visible && this.mNameField != null) {
            if (this.modelData.getContainingObject() instanceof Controller || this.modelData.getContainingObject() instanceof View) {
                this.mNameField.setText(this.modelData.getContainingObject().getName());
                this.mNameField.setEditable(false);
                this.mNameField.setEnabled(false);
            } else {
                this.mNameField.setFocus();
            }
        }
        super.setVisible(visible);
    }

    static {
        PAGE_NAME = TITLE = TextPool.getInstance().getText(2306);
    }

    private class ContextSelectionChangeListener
    implements ISelectionChangedListener {
        private ContextSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty()) {
                DevelopmentObject selection = (DevelopmentObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof DevelopmentObject) {
                    String message = null;
                    if (selection instanceof Model) {
                        message = "Context element cannot be bound to model layer.";
                        ModelSelectionPage.this.setErrorMessage(message);
                    } else {
                        ModelSelectionPage.this.mData.setTargetModelEntity(selection);
                        ModelSelectionPage.this.modelData.setModelClass((ModelClass)selection);
                        ModelSelectionPage.this.modelData.setMethodName("execute" + ModelSelectionPage.this.modelData.getModelClass().getName());
                        if (!ModelSelectionPage.this.userDefined) {
                            String controllerName = ModelSelectionPage.this.getValidControllerName(ModelSelectionPage.this.modelData.getModelClass().getModel().getName() + "Cust");
                            ModelSelectionPage.this.modelData.setCustomControllerName(controllerName);
                            ModelSelectionPage.this.mNameField.setText(ModelSelectionPage.this.modelData.getCustomControllerName());
                            ModelSelectionPage.this.userDefined = false;
                        }
                        ModelSelectionPage.this.wData.setTargetObject(selection);
                        ModelSelectionPage.this.wData.getSourceNode().setMappedObject(selection);
                        ModelSelectionPage.this.wData.getSourceNode().setName(selection.getName());
                        ModelSelectionPage.this.setErrorMessage(null);
                        ModelSelectionPage.this.setPageComplete(true);
                    }
                }
            } else {
                ModelSelectionPage.this.setPageComplete(false);
            }
        }
    }
}

