/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.servicecontroller;

import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ListBarViewer;
import com.sap.ide.webdynpro.controllereditor.context.PropertySourceProvider;
import com.sap.ide.webdynpro.controllereditor.context.SelectableListBarItem;
import com.sap.ide.webdynpro.template.simplescenario.servicecontroller.ModelSelectableListBarItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ModelContextListBarViewer
extends ListBarViewer {
    private PropertySourceProvider mPropertySourceProvider;
    private ControllerUsage[] mControllerUsages;
    private Model[] mModels;

    public ModelContextListBarViewer(PropertySourceProvider provider) {
        super(provider.getOutgoingControllerUsageCount());
        this.mPropertySourceProvider = provider;
    }

    public ModelContextListBarViewer(ControllerUsage[] controllerUsages) {
        super(controllerUsages.length);
        this.mControllerUsages = controllerUsages;
    }

    public ModelContextListBarViewer(Model[] models) {
        this.mModels = models;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            ListBarItem[] listbarItems = this.getTrayItems();
            SelectableListBarItem selectedListBarItem = null;
            if (element instanceof ContextElement) {
                ContextValueNode context = ((Controller)((ContextElement)element).getMDO()).getContext();
                if (context != null) {
                    int i = 0;
                    while (i < listbarItems.length) {
                        if (listbarItems[i] instanceof ContextListBarItem && context.equals(((ContextListBarItem)listbarItems[i]).getContextElement())) {
                            selectedListBarItem = (SelectableListBarItem)listbarItems[i];
                            break;
                        }
                        ++i;
                    }
                }
            } else if (element instanceof Model || element instanceof ModelClass || element instanceof ModelRelationRole || element instanceof ModelClassProperty) {
                Model model = null;
                if (!(element instanceof Model)) {
                    ModelRelation modelRelation;
                    if (element instanceof ModelClass) {
                        model = ((ModelClass)element).getModel();
                    } else if (element instanceof ModelClassProperty) {
                        model = ((ModelClass)((ModelClassProperty)element).getParent()).getModel();
                    } else if (element instanceof ModelRelationRole && (modelRelation = ((ModelRelationRole)element).getModelRelation()) != null) {
                        model = modelRelation.getModel();
                    }
                }
                if (model != null) {
                    int i = 0;
                    while (i < listbarItems.length) {
                        if (listbarItems[i] instanceof ModelSelectableListBarItem && model.equals(((ModelSelectableListBarItem)listbarItems[i]).getModel())) {
                            selectedListBarItem = (SelectableListBarItem)listbarItems[i];
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (selectedListBarItem != null) {
                this.setActiveTrayItem((ListBarItem)selectedListBarItem);
                ISelectionProvider provider = selectedListBarItem.getSelectionProvider();
                if (provider != null) {
                    provider.setSelection(selection);
                    if (provider instanceof TreeViewer) {
                        TreeViewer contextTree = (TreeViewer)provider;
                        if (element instanceof ModelRelationRole) {
                            contextTree.expandToLevel(element, 2);
                        } else {
                            contextTree.expandToLevel(element, 1);
                        }
                    }
                }
            }
        }
    }

    protected void initClientArea(Composite parent) {
        int i;
        ModelSelectableListBarItem trayItem = null;
        ControllerUsage[] usages = this.getControllerUsages();
        Model[] models = this.getModels();
        if (usages != null) {
            i = 0;
            while (i < usages.length) {
                Controller usedController = usages[i].getUsedController();
                if (usedController != null) {
                    trayItem = new ContextListBarItem(usages[i]);
                    this.addTrayItem((ListBarItem)trayItem, false);
                }
                ++i;
            }
        }
        if (models != null) {
            i = 0;
            while (i < models.length) {
                trayItem = new ModelSelectableListBarItem(models[i]);
                this.addTrayItem((ListBarItem)trayItem, false);
                ++i;
            }
        }
        this.registerConrollerUsageObserver(parent);
        this.registerModelUsageObserver(parent);
    }

    private ControllerUsage[] getControllerUsages() {
        if (this.mPropertySourceProvider != null) {
            return this.mPropertySourceProvider.getOutgoingControllerUsages();
        }
        return this.mControllerUsages;
    }

    private Model[] getModels() {
        if (this.mPropertySourceProvider != null) {
            return this.mPropertySourceProvider.getUsedModels();
        }
        return this.mModels;
    }

    private void registerConrollerUsageObserver(Composite composite) {
        if (this.mPropertySourceProvider != null) {
            final ControllerUsageObserver observer = new ControllerUsageObserver();
            this.mPropertySourceProvider.attachControllerUsageObserver((DevelopmentObjectObserver)observer, 24);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ModelContextListBarViewer.this.mPropertySourceProvider.detachControllerUsageObserver((DevelopmentObjectObserver)observer);
                }
            });
        }
    }

    private void registerModelUsageObserver(Composite composite) {
        if (this.mPropertySourceProvider != null) {
            final ModelUsageObserver observer = new ModelUsageObserver();
            this.mPropertySourceProvider.attachModelUsageObserver((DevelopmentObjectObserver)observer, 768);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ModelContextListBarViewer.this.mPropertySourceProvider.detachModelUsageObserver((DevelopmentObjectObserver)observer);
                }
            });
        }
    }

    private class ModelUsageObserver
    implements DevelopmentObjectObserver {
        private ModelUsageObserver() {
        }

        public void update(MetamodelEvent event) {
            block9: {
                Model[] models;
                block10: {
                    if (!(event.getModifiedObject() instanceof Component) && !(event.getModifiedObject() instanceof ComponentInterfaceDefinition)) break block9;
                    models = ModelContextListBarViewer.this.getModels();
                    if (event.getEventId() != 256) break block10;
                    int i = 0;
                    while (i < models.length) {
                        boolean found = false;
                        int j = 0;
                        while (j < ModelContextListBarViewer.this.mTrayItems.size()) {
                            ListBarItem item = (ListBarItem)ModelContextListBarViewer.this.mTrayItems.get(j);
                            if (item instanceof ModelSelectableListBarItem && ((ModelSelectableListBarItem)item).getModel() == models[i]) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found || ModelContextListBarViewer.this.mTrayItems.size() == 0) {
                            ModelSelectableListBarItem trayItem = new ModelSelectableListBarItem(models[i]);
                            ModelContextListBarViewer.this.addTrayItem((ListBarItem)trayItem, true);
                            break block9;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (event.getEventId() != 512) break block9;
                int i = 0;
                while (i < ModelContextListBarViewer.this.mTrayItems.size()) {
                    ListBarItem item = (ListBarItem)ModelContextListBarViewer.this.mTrayItems.get(i);
                    boolean found = false;
                    if (item instanceof ModelSelectableListBarItem) {
                        int j = 0;
                        while (j < models.length) {
                            if (((ModelSelectableListBarItem)item).getModel() == models[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            ModelContextListBarViewer.this.removeTrayItem(i, true);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.update(events[i]);
                ++i;
            }
        }
    }

    private class ControllerUsageObserver
    implements DevelopmentObjectObserver {
        private ControllerUsageObserver() {
        }

        public void update(MetamodelEvent event) {
            block10: {
                ControllerUsage[] usages;
                block11: {
                    if (!(event.getModifiedObject() instanceof Controller) && !(event.getModifiedObject() instanceof ComponentControllerUsage)) break block10;
                    usages = ModelContextListBarViewer.this.getControllerUsages();
                    if (event.getEventId() != 8) break block11;
                    int i = 0;
                    while (i < usages.length) {
                        boolean found = false;
                        if (usages[i].getUsedController() != null) {
                            int j = 0;
                            while (j < ModelContextListBarViewer.this.mTrayItems.size()) {
                                ListBarItem item = (ListBarItem)ModelContextListBarViewer.this.mTrayItems.get(j);
                                if (item instanceof ContextListBarItem && usages[i] != null && ((ContextListBarItem)item).getControllerUsage() == usages[i]) {
                                    found = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!(found && ModelContextListBarViewer.this.mTrayItems.size() != 0 || usages[i] == null)) {
                                ContextListBarItem trayItem = new ContextListBarItem(usages[i]);
                                ModelContextListBarViewer.this.addTrayItem((ListBarItem)trayItem, true);
                                break block10;
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                if (event.getEventId() != 16) break block10;
                int i = 0;
                while (i < ModelContextListBarViewer.this.mTrayItems.size()) {
                    ListBarItem item = (ListBarItem)ModelContextListBarViewer.this.mTrayItems.get(i);
                    boolean found = false;
                    if (item instanceof ContextListBarItem) {
                        int j = 0;
                        while (j < usages.length) {
                            if (usages[j] != null && ((ContextListBarItem)item).getControllerUsage() == usages[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            ModelContextListBarViewer.this.removeTrayItem(i, true);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.update(events[i]);
                ++i;
            }
        }
    }
}

