/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.servicecontroller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.TreeNode;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.servicecontroller.ModelData;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MethodSelectionPage
extends WizardPage
implements IDisplayErrorListener {
    private DevelopmentObject mObject;
    private ModelData modelData;
    private Controller mController;
    private Text mNameField;
    private Button mMethodCheckBox;

    public MethodSelectionPage() {
        super("CustomController");
        this.setTitle("Model Execution");
        this.setDescription("Enter the name for the method if the model has to be executed");
    }

    public MethodSelectionPage(ITemplateData tempData) {
        this();
        this.modelData = (ModelData)tempData;
        this.mController = this.modelData.getController();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        this.addComponent(glp);
        this.setControl((Control)root);
    }

    private void addComponent(IGridLayoutPane gPane) {
        IGridLayoutData gd1 = gPane.createGridLayoutData(4, 1, true, false, 3, 1);
        IGridLayoutPane pane = gPane;
        gd1 = gPane.createGridLayoutData(1, 4, false, false);
        this.mMethodCheckBox = pane.addCheckBox("Generate Method", true, gd1);
        this.mMethodCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    if (((Button)e.widget).getSelection()) {
                        MethodSelectionPage.this.mNameField.setEnabled(true);
                        if (MethodSelectionPage.this.mNameField.getText() == null || MethodSelectionPage.this.mNameField.getText().equals("")) {
                            MethodSelectionPage.this.setVisible(true);
                        }
                    } else {
                        MethodSelectionPage.this.mNameField.setText("");
                        MethodSelectionPage.this.modelData.setMethodName(null);
                        MethodSelectionPage.this.mNameField.setEnabled(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        pane.addPlaceholder();
        pane.addPlaceholder();
        pane.addPlaceholder();
        pane.addPlaceholder();
        pane.addPlaceholder();
        gd1 = pane.createGridLayoutData(1, 4, false, false);
        pane.addTextLabel("Method Name", gd1);
        gd1 = pane.createGridLayoutData(4, 4, true, false);
        String name = "";
        if (this.modelData.getModelClass() != null) {
            name = this.modelData.getModelClass().getName();
            this.modelData.setMethodName(name);
        }
        this.mNameField = pane.addTextField(name, false, gd1);
        this.mNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String errMsg = MethodSelectionPage.this.validateName(MethodSelectionPage.this.mNameField.getText());
                if (errMsg == null) {
                    MethodSelectionPage.this.modelData.setMethodName(MethodSelectionPage.this.mNameField.getText());
                }
                MethodSelectionPage.this.setErrorMessage(errMsg);
                MethodSelectionPage.this.setPageComplete(errMsg == null);
            }
        });
        pane.addPlaceholder();
    }

    private String validateName(String name) {
        Method method;
        if (name == null || name.equals("")) {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        if (this.mController != null && (method = this.mController.getMethod(name)) != null) {
            return "Method already exists.";
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible && this.mNameField != null && this.mMethodCheckBox != null && this.mMethodCheckBox.getSelection()) {
            String name = "";
            if (this.modelData.getModelClass() != null) {
                TreeListItem rootItem;
                TreeNode node = this.modelData.getModelWizardData().getSourceNode();
                if (node != null && (rootItem = this.modelData.getModelWizardData().getHelper().get((Object)node)) != null) {
                    name = (String)rootItem.getProperties().getValue("Name");
                }
                name = name == null || name.equals("") ? "execute" + this.modelData.getModelClass().getName() : "execute" + this.getHungarianNotation(name);
                this.modelData.setMethodName(name);
                this.mNameField.setText(name);
                this.modelData.setMethodNameChanged(true);
            }
        }
        super.setVisible(visible);
        this.mNameField.setFocus();
    }

    private String getHungarianNotation(String name) {
        String newName = null;
        if (name != null) {
            char[] chars = name.trim().toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            newName = new String(chars);
        }
        return newName;
    }

    public void setPageComplete(boolean complete) {
        this.modelData.setValid(complete);
        super.setPageComplete(complete);
    }
}

