/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.actionbutton;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.NavigationData;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PlugsDialog
extends TitleAreaDialog {
    private NavigationData navigationData;
    private Text mPlugNameField;

    public PlugsDialog(NavigationData data) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.navigationData = data;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle("Outbound Plug Properties");
        this.setMessage("Enter a name for the outbound plug");
        this.getShell().setText("Outbound Plug Properties");
        Label label = new Label(contents, 0);
        label.setText("Name");
        this.mPlugNameField = new Text(contents, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.mPlugNameField.setLayoutData((Object)gridData);
        if (this.navigationData.getPlugName() != null) {
            this.mPlugNameField.setText(this.navigationData.getPlugName());
        }
        this.mPlugNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String errMsg = PlugsDialog.this.validateName();
                PlugsDialog.this.setErrorMessage(errMsg);
                PlugsDialog.super.getButton(0).setEnabled(errMsg == null);
            }
        });
        return contents;
    }

    protected void okPressed() {
        if (!this.mPlugNameField.getText().equals(this.navigationData.getPlugName())) {
            this.navigationData.setUserDefinedOPlug(true);
        }
        this.navigationData.setPlugName(this.mPlugNameField.getText());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private String validateName() {
        String text = this.mPlugNameField.getText();
        if (text == null || text.equals("")) {
            return "Outbound Plug name cannot be empty.";
        }
        DevelopmentObject devObj = this.navigationData.getContainingObject();
        if (devObj != null) {
            View view = null;
            view = devObj instanceof View ? (View)devObj : (View)devObj.getMDO();
            if (view.getOutboundPlug(text) != null) {
                return "The Outbound plug " + text + " already exists.";
            }
        }
        if (!CheckServices.isValidIdentifier((String)text)) {
            return CoreTextPool.getInstance().getText(39, (Object)text);
        }
        return null;
    }
}

