/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.actionbutton;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.NavigationData;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.PlugsDialog;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class OptionalDetailsPage
extends WizardPage
implements IDisplayErrorListener {
    private DevelopmentObject mObject;
    private NavigationData mData;
    private Controller mController;
    private Button mFirePlugCheckBox;
    private Combo mOPlugNameCombo;
    private Button mOPlugButton;
    private Button mMethodsCheckBox;
    private Combo mControllerCombo;
    private Combo mMethodsCombo;

    public OptionalDetailsPage(DevelopmentObject object, ITemplateData data) {
        super("Navigation View");
        this.setTitle("Event Handler Properties");
        this.setDescription("Enter the details for the eventhandler associated with the button");
        this.mObject = object;
        if (data instanceof NavigationData) {
            this.mData = (NavigationData)data;
        }
        this.mController = object instanceof View ? ((View)this.mObject).getViewController() : ((View)this.mObject.getMDO()).getViewController();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        this.addMethodsComponent(glp);
        glp.addHorizontalSeparator();
        this.addOPlugComponent(glp);
    }

    private void addOPlugComponent(IGridLayoutPane gPane) {
        IGridLayoutData gData = gPane.createGridLayoutData(4, 1, true, false, 3, 1);
        IGridLayoutPane childPane = gPane.addGridLayoutPane(" Fire Plug ", 3, gData);
        gData = childPane.createGridLayoutData(1, 1, false, false);
        this.mFirePlugCheckBox = childPane.addCheckBox("Fire Plug", false, gData);
        childPane.addPlaceholder();
        childPane.addPlaceholder();
        this.mFirePlugCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    if (((Button)e.widget).getSelection()) {
                        OptionalDetailsPage.this.mData.setFirePlug(true);
                        OptionalDetailsPage.this.mOPlugNameCombo.setEnabled(true);
                        OptionalDetailsPage.this.mOPlugNameCombo.setText(OptionalDetailsPage.this.mData.getPlugName());
                        OptionalDetailsPage.this.mOPlugButton.setEnabled(true);
                    } else {
                        OptionalDetailsPage.this.mData.setFirePlug(false);
                        OptionalDetailsPage.this.mData.setPlug(null);
                        OptionalDetailsPage.this.mOPlugNameCombo.setEnabled(false);
                        OptionalDetailsPage.this.mOPlugButton.setEnabled(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Outbound Plug", gData);
        gData = childPane.createGridLayoutData(4, 4, true, false);
        this.mOPlugNameCombo = childPane.addComboBox(this.mData.getOutboundPlugs(), this.mData.getPlugName(), true, gData);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        this.mOPlugButton = childPane.addPushButton("New", gData);
        this.mOPlugNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = OptionalDetailsPage.this.mOPlugNameCombo.getSelectionIndex();
                if (index != -1) {
                    OptionalDetailsPage.this.mData.setPlug(index);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mOPlugButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlugsDialog dialog = new PlugsDialog(OptionalDetailsPage.this.mData);
                dialog.open();
                dialog.close();
                if (dialog.getReturnCode() == 0 && OptionalDetailsPage.this.mData.getPlugName() != null) {
                    OptionalDetailsPage.this.mOPlugNameCombo.setItems(OptionalDetailsPage.this.mData.getOutboundPlugs());
                    OptionalDetailsPage.this.mOPlugNameCombo.setText(OptionalDetailsPage.this.mData.getPlugName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        this.mFirePlugCheckBox.setSelection(false);
        this.mOPlugNameCombo.setEnabled(false);
        this.mOPlugButton.setEnabled(false);
    }

    private void addMethodsComponent(IGridLayoutPane gPane) {
        IGridLayoutData gData = gPane.createGridLayoutData(4, 1, true, false, 3, 1);
        IGridLayoutPane childPane = gPane.addGridLayoutPane(" Invoke Methods ", 3, gData);
        gData = childPane.createGridLayoutData(1, 1, false, false);
        this.mMethodsCheckBox = childPane.addCheckBox("Call Method", false, gData);
        childPane.addPlaceholder();
        childPane.addPlaceholder();
        this.mMethodsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    if (((Button)e.widget).getSelection()) {
                        if (OptionalDetailsPage.this.mData.getControllerNames() != null && OptionalDetailsPage.this.mData.getControllerNames().length > 0) {
                            OptionalDetailsPage.this.mData.setMethodCalled(true);
                            OptionalDetailsPage.this.mControllerCombo.setEnabled(true);
                            OptionalDetailsPage.this.mMethodsCombo.setEnabled(true);
                        }
                    } else {
                        OptionalDetailsPage.this.mData.setMethodCalled(false);
                        OptionalDetailsPage.this.mData.setControllerUsage(null);
                        OptionalDetailsPage.this.mData.setMethodCalled(null);
                        OptionalDetailsPage.this.mControllerCombo.setText(OptionalDetailsPage.this.mControllerCombo.getItem(0));
                        OptionalDetailsPage.this.mMethodsCombo.setItems(new String[]{"<None>"});
                        OptionalDetailsPage.this.mMethodsCombo.setText("<None>");
                        OptionalDetailsPage.this.mControllerCombo.setEnabled(false);
                        OptionalDetailsPage.this.mMethodsCombo.setEnabled(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Controller ", gData);
        gData = childPane.createGridLayoutData(4, 1, true, false);
        this.mControllerCombo = childPane.addComboBox(this.mData.getControllerNames(), "<None>", true, gData);
        gData = childPane.createGridLayoutData(1, 1, true, false);
        childPane.addPlaceholder(gData);
        this.mControllerCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionalDetailsPage.this.mControllerCombo.getSelectionIndex() == 0) {
                    OptionalDetailsPage.this.mData.setControllerUsage(null);
                    OptionalDetailsPage.this.mData.setMethodCalled(null);
                    OptionalDetailsPage.this.mMethodsCombo.setItems(new String[]{"<None>"});
                    OptionalDetailsPage.this.mMethodsCombo.setText("<None>");
                } else if (OptionalDetailsPage.this.mControllerCombo.getSelectionIndex() != -1) {
                    OptionalDetailsPage.this.mData.setControllerUsage(OptionalDetailsPage.this.mControllerCombo.getSelectionIndex());
                    Controller usage = OptionalDetailsPage.this.mData.getControllerUsage();
                    OptionalDetailsPage.this.mData.setMethods(usage.getMethods());
                    OptionalDetailsPage.this.mMethodsCombo.setItems(OptionalDetailsPage.this.mData.getMethodNames());
                    if (OptionalDetailsPage.this.mMethodsCombo.getItemCount() > 0) {
                        OptionalDetailsPage.this.mData.setMethodCalled(OptionalDetailsPage.this.mData.getMethods()[0]);
                        OptionalDetailsPage.this.mMethodsCombo.setText(OptionalDetailsPage.this.mMethodsCombo.getItem(0));
                    } else {
                        OptionalDetailsPage.this.mData.setMethodCalled(null);
                        OptionalDetailsPage.this.mMethodsCombo.setItems(new String[]{"<None>"});
                        OptionalDetailsPage.this.mMethodsCombo.setText("<None>");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Methods ", gData);
        gData = childPane.createGridLayoutData(4, 1, true, false);
        this.mMethodsCombo = childPane.addComboBox(new String[]{"<None>"}, "<None>", true, gData);
        gData = childPane.createGridLayoutData(1, 1, true, false);
        childPane.addPlaceholder(gData);
        this.mMethodsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (OptionalDetailsPage.this.mMethodsCombo.getSelectionIndex() != -1) {
                    OptionalDetailsPage.this.mData.setMethodCalled(OptionalDetailsPage.this.mMethodsCombo.getSelectionIndex());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        this.mMethodsCheckBox.setSelection(false);
        this.mControllerCombo.setEnabled(false);
        this.mMethodsCombo.setEnabled(false);
    }

    private boolean isValidOutboundPlug(String name) {
        if (name != null) {
            String[] oPlugNames = this.mData.getOutboundPlugs();
            if (oPlugNames != null) {
                int i = 0;
                while (i < oPlugNames.length) {
                    if (name.equalsIgnoreCase(oPlugNames[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private String getValidOutboundPlugName(String name) {
        counter = 0;
        if (name != null) ** GOTO lbl5
        return this.getValidOutboundPlugName("_OPlug");
lbl-1000:
        // 1 sources

        {
            name = name + counter;
lbl5:
            // 2 sources

            ** while (!this.isValidOutboundPlug((String)name))
        }
lbl6:
        // 1 sources

        return name;
    }

    private String validateName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        this.mData.setValid(complete);
        super.setPageComplete(complete);
    }
}

