/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.actionbutton;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Button;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.ActionsDialog;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.EventHandlersDialog;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.NavigationData;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateButtonPage
extends WizardPage
implements IDisplayErrorListener {
    private DevelopmentObject mObject;
    private NavigationData mData;
    private Controller mController;
    private Text mNameField;
    private Combo mActionNameCombo;
    private Combo mEventNameCombo;
    private org.eclipse.swt.widgets.Button mActionButton;
    private org.eclipse.swt.widgets.Button mEventButton;

    public CreateButtonPage(DevelopmentObject object, ITemplateData data) {
        super("Navigation View");
        this.setTitle("Button Properties");
        this.setDescription("Enter the properties for the button");
        this.mObject = object;
        if (data instanceof NavigationData) {
            this.mData = (NavigationData)data;
        }
        this.mController = object instanceof View ? ((View)this.mObject).getViewController() : ((View)this.mObject.getMDO()).getViewController();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        this.addNameComponent(glp);
        glp.addHorizontalSeparator();
        glp.addPlaceholder();
        glp.addPlaceholder();
        glp.addPlaceholder();
        this.addActionEventComponent(glp);
        this.setControl((Control)root);
    }

    private void addNameComponent(IGridLayoutPane gPane) {
        IGridLayoutData gd = gPane.createGridLayoutData(1, 4, false, false);
        gPane.addTextLabel("Button Label   ");
        gd = gPane.createGridLayoutData(4, 4, true, false);
        this.mNameField = gPane.addTextField("", false, gd);
        this.mNameField.setText(this.mData.getText());
        this.mNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CreateButtonPage.this.mNameField.getText() == null || CreateButtonPage.this.mNameField.getText().equals("")) {
                    CreateButtonPage.this.mData.setText(CreateButtonPage.this.mNameField.getText());
                    if (!CreateButtonPage.this.mData.isUserDefinedAction()) {
                        CreateButtonPage.this.mData.setActionName("");
                        CreateButtonPage.this.mActionNameCombo.setItems(CreateButtonPage.this.mData.getActionHandlers());
                        CreateButtonPage.this.mActionNameCombo.setText(CreateButtonPage.this.mData.getActionName());
                    }
                    if (!CreateButtonPage.this.mData.isUserDefinedEvent()) {
                        CreateButtonPage.this.mData.setEventHandlerName("");
                        CreateButtonPage.this.mEventNameCombo.setItems(CreateButtonPage.this.mData.getEventHandlers());
                        CreateButtonPage.this.mEventNameCombo.setText(CreateButtonPage.this.mData.getEventHandlerName());
                    }
                    CreateButtonPage.this.setErrorMessage("Label cannot be empty.");
                    CreateButtonPage.this.setPageComplete(false);
                    return;
                }
                String errMsg = CreateButtonPage.this.validateLabel(CreateButtonPage.this.mNameField.getText());
                if (errMsg == null || errMsg.equals("")) {
                    CreateButtonPage.this.mData.setText(CreateButtonPage.this.mNameField.getText());
                    if (!CreateButtonPage.this.mData.isUserDefinedAction()) {
                        CreateButtonPage.this.mData.setActionName(CreateButtonPage.this.findActionName(CreateButtonPage.this.mNameField.getText().trim()));
                        CreateButtonPage.this.mActionNameCombo.setItems(CreateButtonPage.this.mData.getActionHandlers());
                        CreateButtonPage.this.mActionNameCombo.setText(CreateButtonPage.this.mData.getActionName());
                    }
                    if (!CreateButtonPage.this.mData.isUserDefinedEvent()) {
                        CreateButtonPage.this.mData.setEventHandlerName("onAction" + CreateButtonPage.this.mData.getActionName());
                        CreateButtonPage.this.mEventNameCombo.setItems(CreateButtonPage.this.mData.getEventHandlers());
                        CreateButtonPage.this.mEventNameCombo.setText(CreateButtonPage.this.mData.getEventHandlerName());
                    }
                }
                CreateButtonPage.this.setErrorMessage(errMsg);
                CreateButtonPage.this.setPageComplete(errMsg == null);
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
    }

    private void addActionEventComponent(IGridLayoutPane gPane) {
        String initName = null;
        Button button = null;
        if (this.mData.getContainingObject() != null && this.mData.getContainingObject() instanceof Button) {
            button = (Button)this.mData.getContainingObject();
        }
        IGridLayoutData gData = gPane.createGridLayoutData(4, 1, true, false, 3, 1);
        IGridLayoutPane childPane = gPane;
        gData = gPane.createGridLayoutData(1, 1, false, false);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Action", gData);
        initName = this.mData.getAction() != null ? this.mData.getAction().getName() : this.mData.getActionName();
        gData = childPane.createGridLayoutData(4, 4, true, false);
        this.mActionNameCombo = childPane.addComboBox(this.mData.getActionHandlers(), initName, true, gData);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        this.mActionButton = childPane.addPushButton("New", gData);
        this.mActionNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = CreateButtonPage.this.mActionNameCombo.getSelectionIndex();
                if (index != -1) {
                    CreateButtonPage.this.mData.setAction(index);
                }
                if (CreateButtonPage.this.mActionNameCombo.getSelectionIndex() != -1) {
                    Action action = CreateButtonPage.this.mData.getAction();
                    if (action != null && action.getEventHandler() != null) {
                        CreateButtonPage.this.mData.setEventHandler(action.getEventHandler());
                        CreateButtonPage.this.mEventNameCombo.setText(action.getEventHandler().getName());
                    } else {
                        CreateButtonPage.this.mData.setEventHandler(null);
                        CreateButtonPage.this.mEventNameCombo.setText(CreateButtonPage.this.mData.getEventHandlerName());
                    }
                }
                if (CreateButtonPage.this.mData.isEventHandlerComplete()) {
                    CreateButtonPage.this.setMessage("The EventHandler associated has implementation and cannot be overridden.", 2);
                    CreateButtonPage.this.getWizard().getContainer().updateButtons();
                } else {
                    CreateButtonPage.this.setMessage("Enter the properties for the new button", 0);
                    CreateButtonPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mActionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ActionsDialog dialog = new ActionsDialog(CreateButtonPage.this.mData);
                dialog.open();
                dialog.close();
                if (dialog.getReturnCode() == 0 && CreateButtonPage.this.mData.getActionName() != null) {
                    CreateButtonPage.this.mActionNameCombo.setItems(CreateButtonPage.this.mData.getActionHandlers());
                    CreateButtonPage.this.mActionNameCombo.setText(CreateButtonPage.this.mData.getActionName());
                    if (!CreateButtonPage.this.mData.isUserDefinedEvent()) {
                        CreateButtonPage.this.mData.setEventHandlerName("onAction" + CreateButtonPage.this.mData.getActionName());
                        CreateButtonPage.this.mEventNameCombo.setItems(CreateButtonPage.this.mData.getEventHandlers());
                        CreateButtonPage.this.mEventNameCombo.setText(CreateButtonPage.this.mData.getEventHandlerName());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Event", gData);
        initName = this.mData.getEventHandler() != null ? this.mData.getEventHandler().getName() : this.mData.getEventHandlerName();
        gData = childPane.createGridLayoutData(4, 4, true, false);
        this.mEventNameCombo = childPane.addComboBox(this.mData.getEventHandlers(), initName, true, gData);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        this.mEventButton = childPane.addPushButton("New", gData);
        this.mEventNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = CreateButtonPage.this.mEventNameCombo.getSelectionIndex();
                if (index != -1) {
                    CreateButtonPage.this.mData.setEventHandler(index);
                }
                if (CreateButtonPage.this.mData.isEventHandlerComplete()) {
                    CreateButtonPage.this.setMessage("The EventHandler associated has implementation and cannot be overridden.", 2);
                    CreateButtonPage.this.getWizard().getContainer().updateButtons();
                } else {
                    CreateButtonPage.this.setMessage("Enter the properties for the new button", 0);
                    CreateButtonPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mEventButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlersDialog dialog = new EventHandlersDialog(CreateButtonPage.this.mData);
                dialog.open();
                dialog.close();
                if (dialog.getReturnCode() == 0 && CreateButtonPage.this.mData.getActionName() != null) {
                    CreateButtonPage.this.mEventNameCombo.setItems(CreateButtonPage.this.mData.getEventHandlers());
                    CreateButtonPage.this.mEventNameCombo.setText(CreateButtonPage.this.mData.getEventHandlerName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
    }

    private String findActionName(String name) {
        if (name == null || name.equals("")) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        char c = ' ';
        int i = 0;
        while (i < name.length()) {
            c = name.charAt(i);
            if (c != ' ') {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String validateLabel(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == ' ' || Character.isDigit(c))) {
                return CoreTextPool.getInstance().getText(2);
            }
            ++i;
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        this.mData.setValid(complete);
        super.setPageComplete(complete);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && !this.mData.isEventHandlerComplete();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.mData.isEventHandlerComplete();
    }
}

