/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.actionbutton;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.DeclarationTypeEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.ActionsDialog;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.EventHandlersDialog;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.NavigationData;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ButtonDetailsPage
extends WizardPage
implements IDisplayErrorListener {
    private DevelopmentObject mObject;
    private NavigationData mData;
    private Controller mController;
    private Text mNameField;
    private Text mActionNameField;
    private Text mEventNameField;
    private Button mActionButton;
    private Button mEventButton;
    private Combo mActionNameCombo;
    private Combo mEventNameCombo;
    private boolean userDefinedAction;
    private boolean userDefinedEvent;

    public ButtonDetailsPage(DevelopmentObject object, ITemplateData data) {
        super("Navigation View");
        this.setTitle("Button Properties");
        this.setDescription("Enter the properties for the new button");
        this.mObject = object;
        if (data instanceof NavigationData) {
            this.mData = (NavigationData)data;
        }
        this.mController = object instanceof View ? ((View)this.mObject).getViewController() : ((View)this.mObject.getMDO()).getViewController();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        this.addNameComponent(glp);
        glp.addHorizontalSeparator();
        glp.addPlaceholder();
        glp.addPlaceholder();
        glp.addPlaceholder();
        this.addActionEventComponent(glp);
        this.getDefaultName();
        this.setControl((Control)root);
    }

    private void addNameComponent(IGridLayoutPane gPane) {
        IGridLayoutData gd = gPane.createGridLayoutData(1, 4, false, false);
        gPane.addTextLabel("Button Label   ");
        gd = gPane.createGridLayoutData(4, 4, true, false);
        this.mNameField = gPane.addTextField("", false, gd);
        this.mNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ButtonDetailsPage.this.mNameField.getText() == null || ButtonDetailsPage.this.mNameField.getText().equals("")) {
                    ButtonDetailsPage.this.mData.setText(ButtonDetailsPage.this.mNameField.getText());
                    if (!ButtonDetailsPage.this.userDefinedAction) {
                        ButtonDetailsPage.this.mActionNameField.setText("");
                        ButtonDetailsPage.this.mData.setActionName(null);
                        ButtonDetailsPage.this.userDefinedAction = false;
                    }
                    if (!ButtonDetailsPage.this.userDefinedEvent) {
                        ButtonDetailsPage.this.mEventNameField.setText("");
                        ButtonDetailsPage.this.mData.setEventHandlerName(null);
                        ButtonDetailsPage.this.userDefinedEvent = false;
                    }
                    ButtonDetailsPage.this.setPageComplete(false);
                    return;
                }
                String errMsg = ButtonDetailsPage.this.validateLabel(ButtonDetailsPage.this.mNameField.getText());
                if (errMsg == null || errMsg.equals("")) {
                    ButtonDetailsPage.this.mData.setText(ButtonDetailsPage.this.mNameField.getText());
                    if (!ButtonDetailsPage.this.userDefinedAction) {
                        ButtonDetailsPage.this.mActionNameField.setText(ButtonDetailsPage.this.findActionName(ButtonDetailsPage.this.mNameField.getText().trim()));
                        ButtonDetailsPage.this.mData.setActionName(ButtonDetailsPage.this.mActionNameField.getText());
                        ButtonDetailsPage.this.userDefinedAction = false;
                    }
                    if (!ButtonDetailsPage.this.userDefinedEvent) {
                        ButtonDetailsPage.this.mEventNameField.setText("onAction" + ButtonDetailsPage.this.mActionNameField.getText());
                        ButtonDetailsPage.this.mData.setEventHandlerName(ButtonDetailsPage.this.mEventNameField.getText());
                        ButtonDetailsPage.this.userDefinedEvent = false;
                    }
                    ButtonDetailsPage.this.validatePage();
                } else {
                    ButtonDetailsPage.this.setErrorMessage(errMsg);
                    ButtonDetailsPage.this.setPageComplete(false);
                }
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
    }

    private void addActionEventComponent(IGridLayoutPane gPane) {
        IGridLayoutData gData = gPane.createGridLayoutData(4, 1, true, false, 3, 1);
        IGridLayoutPane childPane = gPane;
        gData = gPane.createGridLayoutData(1, 1, false, false);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Action", gData);
        gData = childPane.createGridLayoutData(4, 4, true, false);
        this.mActionNameField = childPane.addTextField("", false, gData);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        this.mActionButton = childPane.addPushButton("New", gData);
        this.mActionNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String actionName = ButtonDetailsPage.this.mActionNameField.getText();
                if (actionName == null || actionName.equals("")) {
                    ButtonDetailsPage.this.mData.setActionName(null);
                } else {
                    if (actionName.equals(ButtonDetailsPage.this.mNameField.getText())) {
                        ButtonDetailsPage.this.validatePage();
                        return;
                    }
                    ButtonDetailsPage.this.mData.setAction(null);
                    ButtonDetailsPage.this.userDefinedAction = true;
                    String errMsg = ButtonDetailsPage.this.validateName(actionName);
                    if (errMsg == null || errMsg.equals("")) {
                        ButtonDetailsPage.this.mData.setActionName(actionName);
                        if (!ButtonDetailsPage.this.userDefinedEvent) {
                            ButtonDetailsPage.this.mEventNameField.setText("onAction" + actionName);
                            ButtonDetailsPage.this.mData.setEventHandlerName(ButtonDetailsPage.this.mEventNameField.getText());
                            ButtonDetailsPage.this.userDefinedEvent = false;
                        }
                        ButtonDetailsPage.this.validatePage();
                    } else {
                        ButtonDetailsPage.this.setErrorMessage(errMsg);
                        ButtonDetailsPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.mActionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ActionsDialog dialog = new ActionsDialog(ButtonDetailsPage.this.mData);
                dialog.open();
                dialog.close();
                if (ButtonDetailsPage.this.mData.getAction() != null) {
                    ButtonDetailsPage.this.userDefinedAction = true;
                    ButtonDetailsPage.this.mActionNameField.setText(ButtonDetailsPage.this.mData.getAction().getName());
                    if (ButtonDetailsPage.this.mData.getAction() != null && ButtonDetailsPage.this.mData.getAction().getEventHandler() != null) {
                        ButtonDetailsPage.this.mEventNameField.setText(ButtonDetailsPage.this.mData.getAction().getEventHandler().getName());
                        ButtonDetailsPage.this.mData.setEventHandler(ButtonDetailsPage.this.mData.getAction().getEventHandler());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gData = childPane.createGridLayoutData(1, 4, false, false);
        childPane.addTextLabel("Event", gData);
        gData = childPane.createGridLayoutData(4, 4, true, false);
        this.mEventNameField = childPane.addTextField("", false, gData);
        gData = childPane.createGridLayoutData(1, 4, false, false);
        this.mEventButton = childPane.addPushButton("New", gData);
        this.mEventNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String eventName = ButtonDetailsPage.this.mEventNameField.getText();
                if (eventName == null || eventName.equals("")) {
                    ButtonDetailsPage.this.mData.setEventHandlerName(null);
                } else {
                    if (eventName.equals("onAction" + ButtonDetailsPage.this.mActionNameField.getText())) {
                        return;
                    }
                    ButtonDetailsPage.this.userDefinedEvent = true;
                    String errMsg = ButtonDetailsPage.this.validateName(eventName);
                    if (errMsg == null || errMsg.equals("")) {
                        ButtonDetailsPage.this.mData.setEventHandlerName(eventName);
                        ButtonDetailsPage.this.validatePage();
                    } else {
                        ButtonDetailsPage.this.setErrorMessage(errMsg);
                        ButtonDetailsPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.mEventButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlersDialog dialog = new EventHandlersDialog(ButtonDetailsPage.this.mData);
                dialog.open();
                dialog.close();
                if (ButtonDetailsPage.this.mData.getEventHandler() != null) {
                    ButtonDetailsPage.this.userDefinedEvent = true;
                    ButtonDetailsPage.this.mEventNameField.setText(ButtonDetailsPage.this.mData.getEventHandler().getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gPane.addPlaceholder();
        gPane.addPlaceholder();
        gPane.addPlaceholder();
    }

    private void getDefaultName() {
        String defName = "Button";
        int counter = 0;
        while (this.validateName(defName) != null) {
            defName = "Button" + counter++;
        }
        this.mNameField.setText(defName);
        this.mData.setText(defName);
    }

    private String findActionName(String name) {
        if (name == null || name.equals("")) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        char c = ' ';
        int i = 0;
        while (i < name.length()) {
            c = name.charAt(i);
            if (c != ' ') {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String validateLabel(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == ' ' || Character.isDigit(c))) {
                return CoreTextPool.getInstance().getText(2);
            }
            ++i;
        }
        return null;
    }

    private String validateName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        return null;
    }

    private boolean isNameAvailableForElement(String name, DevelopmentObject element) {
        if (element.getName().equalsIgnoreCase(name)) {
            return false;
        }
        MetaClass lClass = element.getMetaClass();
        while (lClass != null) {
            Aggregation[] lAggregations = lClass.getAggregations();
            int i = 0;
            while (i < lAggregations.length) {
                Aggregation lAggregation = lAggregations[i];
                if (lAggregation.getDeclarationType() != DeclarationTypeEnum.ABSTRACT) {
                    Class<?> lJavaClass = element.getClass();
                    Class<?>[] lInterfaces = lJavaClass.getInterfaces();
                    int k = 0;
                    while (k < lInterfaces.length) {
                        Class[] lArray = new Class[]{};
                        Method lMethod = null;
                        try {
                            lMethod = lInterfaces[k].getMethod("get" + lAggregation.getName(), lArray);
                        }
                        catch (NoSuchMethodException e) {
                            Plugin.internalError(((Object)((Object)this)).getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                        }
                        Object ret = null;
                        if (lMethod != null) {
                            Object[] lArgs = new Object[]{};
                            DevelopmentObject[] lObjects = null;
                            DevelopmentObject lObject = null;
                            try {
                                ret = lMethod.invoke((Object)element, lArgs);
                            }
                            catch (InvocationTargetException e) {
                                Plugin.internalError(((Object)((Object)this)).getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                            }
                            catch (IllegalAccessException e) {
                                Plugin.internalError(((Object)((Object)this)).getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                            }
                            if (ret instanceof DevelopmentObject[]) {
                                lObjects = (DevelopmentObject[])ret;
                                int j = 0;
                                while (j < lObjects.length) {
                                    if (lObjects[j].getName().equals(name)) {
                                        return false;
                                    }
                                    if (!this.isNameAvailableForElement(name, lObjects[j])) {
                                        return false;
                                    }
                                    ++j;
                                }
                            } else if (ret instanceof DevelopmentObject) {
                                lObject = (DevelopmentObject)ret;
                                if (lObject.getName().equalsIgnoreCase(name)) {
                                    return false;
                                }
                                if (!this.isNameAvailableForElement(name, lObject)) {
                                    return false;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            lClass = lClass.getSuperClass();
        }
        return true;
    }

    private void validatePage() {
        String name = null;
        String errMsg = null;
        name = this.mActionNameField.getText();
        errMsg = this.validateName(name);
        this.setErrorMessage(errMsg);
        if (errMsg == null) {
            name = this.mEventNameField.getText();
            errMsg = this.validateName(name);
            this.setErrorMessage(errMsg);
        }
        this.setPageComplete(errMsg == null);
    }

    public void setPageComplete(boolean complete) {
        this.mData.setValid(complete);
        super.setPageComplete(complete);
    }
}

