/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.actionbutton;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.simplescenario.actionbutton.NavigationData;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ActionsDialog
extends TitleAreaDialog {
    private NavigationData navigationData;
    private Text mActionNameField;

    public ActionsDialog(NavigationData data) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.navigationData = data;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 3;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle("Action Properties");
        this.setMessage("Enter a name for the action");
        this.getShell().setText("Action Properties");
        Label label = new Label(contents, 0);
        label.setText("Name");
        this.mActionNameField = new Text(contents, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.mActionNameField.setLayoutData((Object)gridData);
        if (this.navigationData.getActionName() != null) {
            this.mActionNameField.setText(this.navigationData.getActionName());
        }
        this.mActionNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String errMsg = ActionsDialog.this.validateName();
                ActionsDialog.this.setErrorMessage(errMsg);
                ActionsDialog.super.getButton(0).setEnabled(errMsg == null);
            }
        });
        return contents;
    }

    protected void okPressed() {
        if (!this.mActionNameField.getText().equals(this.navigationData.getActionName())) {
            this.navigationData.setUserDefinedAction(true);
        }
        this.navigationData.setActionName(this.mActionNameField.getText());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private String validateName() {
        String text = this.mActionNameField.getText();
        if (text == null || text.equals("")) {
            return "Action name cannot be empty.";
        }
        DevelopmentObject devObj = this.navigationData.getContainingObject();
        if (devObj != null) {
            Controller controller = null;
            controller = devObj instanceof View ? ((View)devObj).getViewController() : ((View)devObj.getMDO()).getViewController();
            if (controller.getAction(text) != null) {
                return "The Action " + text + " already exists.";
            }
        }
        if (!CheckServices.isValidIdentifier((String)text)) {
            return CoreTextPool.getInstance().getText(39, (Object)text);
        }
        return null;
    }
}

