/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.wizards.applicationproperty;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.ApplicationProperty;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.applicationeditor.Plugin;
import com.sap.ide.webdynpro.applicationeditor.wizards.applicationproperty.CreateApplicationPropertyWizardData;
import com.sap.ide.webdynpro.applicationeditor.wizards.applicationproperty.CreateApplicationPropertyWizardPropertiesPage;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.applicationproperty.ApplicationPropertyService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateApplicationPropertyWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(120);
    private CreateApplicationPropertyWizardData mData = null;
    private CreateApplicationPropertyWizardPropertiesPage mPropertiesPage = null;
    private Application mApplication = null;

    public CreateApplicationPropertyWizard(Application application) {
        this(application, new CreateApplicationPropertyWizardData());
    }

    public CreateApplicationPropertyWizard(Application application, CreateApplicationPropertyWizardData data) {
        this.mData = data;
        this.mApplication = application;
        this.setWindowTitle(mTextPool.getText(150));
    }

    public boolean performFinish() {
        String error = null;
        if (this.mData.getDefinition() == null) {
            error = ApplicationPropertyService.isNewNameValid((String)this.mData.getName(), (Application)this.mApplication);
        }
        if (error != null) {
            this.mPropertiesPage.setErrorMessage(error);
            return false;
        }
        WebDynproRoot webDynproRoot = (WebDynproRoot)this.mApplication.getRoot();
        webDynproRoot.disableAutoNotify();
        ApplicationProperty property = null;
        try {
            property = this.mApplication.createApplicationProperty(this.mData.getName());
        }
        catch (CreateException e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", e.getMessage(), e, true);
            this.mPropertiesPage.setErrorMessage(e.getMessage());
            webDynproRoot.notifyObservers();
            webDynproRoot.enableAutoNotify();
            return false;
        }
        property.setValue(this.mData.getValue());
        if (this.mData.getDefinition() != null) {
            property.setPropertyDefinition(this.mData.getDefinition());
            if (!this.mApplication.hasPropertyDefinitionSet(this.mData.getDefinition().getDefinitionSet())) {
                this.mApplication.addPropertyDefinitionSet(this.mData.getDefinition().getDefinitionSet());
            }
        }
        webDynproRoot.notifyObservers();
        webDynproRoot.enableAutoNotify();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateApplicationPropertyWizardPropertiesPage(this.mData, this.mApplication);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public CreateApplicationPropertyWizardData getData() {
        return this.mData;
    }
}

