/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.wizards.application;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.applicationeditor.wizards.application.CreateApplicationWizardData;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceApplicationEditorPlugin;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.component.ComponentWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateApplicationWizardPropertiesPage
extends WizardPage {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private CreateApplicationWizardData mData = null;
    private WebDynproRoot mRoot = null;
    private ComponentWizardData mComponentWizardData = null;
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mPackageButton = null;
    private Button mAuthenticationButton = null;
    private List mSourcePathList = null;
    private boolean mDeletePackageMessage;
    private boolean mDeleteNameMessage;

    public CreateApplicationWizardPropertiesPage(CreateApplicationWizardData data, WebDynproRoot root, ComponentWizardData componentWizardData) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_APPLICATION_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mData = data;
        this.mRoot = root;
        this.mComponentWizardData = componentWizardData;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane propertyPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        propertyPane.addTextLabel(mTextPool.getText(103));
        IGridLayoutData gd = propertyPane.createGridLayoutData(4, 1, true, false);
        this.mNameField = propertyPane.addTextField(this.mData.getName(), false, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        propertyPane.addPlaceholder();
        propertyPane.addTextLabel(mTextPool.getText(104));
        gd = propertyPane.createGridLayoutData(4, 1, true, false);
        this.mPackageField = propertyPane.addTextField(this.mData.getPackage(), false, gd);
        this.mPackageField.addModifyListener((ModifyListener)new PackageModifyListener());
        this.mPackageButton = propertyPane.addPushButton(mTextPool.getText(105));
        this.mPackageButton.addSelectionListener((SelectionListener)new PackageButtonSelectionListener());
        gd = propertyPane.createGridLayoutData(4, 1, true, false, 3, 1);
        this.mAuthenticationButton = propertyPane.addCheckBox(mTextPool.getText(136), this.mData.isNeedsAuthentication(), gd);
        this.mAuthenticationButton.addSelectionListener((SelectionListener)new AuthenticationButtonSelectionListener());
        gd = propertyPane.createGridLayoutData(4, 1, true, false, 3, 1);
        propertyPane.addPlaceholder(gd);
        propertyPane.addHorizontalSeparator();
        propertyPane.addTextLabel(mCoreTextPool.getText(207));
        gd = propertyPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = propertyPane.addList(items, false, gd);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
        this.setPageComplete(false);
    }

    private boolean validatePage() {
        String nameInput = this.mData.getName();
        String packageInput = this.mData.getPackage();
        this.mDeleteNameMessage = true;
        this.mDeletePackageMessage = true;
        nameInput = CheckServices.checkFirstCharacter((Text)this.mNameField);
        IStatus applicationStatus = ApplicationService.isNewApplicationNameValid((String)nameInput, (String)packageInput, (int)0);
        if (applicationStatus.getSeverity() == 2) {
            this.setMessage(applicationStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (applicationStatus.getSeverity() == 4) {
            this.setErrorMessage(applicationStatus.getMessage());
            return false;
        }
        String error = null;
        packageInput = CheckServices.convertToLowerCase((Text)this.mPackageField);
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        Application application = null;
        try {
            application = this.mRoot.getApplication(this.mData.getPackage(), this.mData.getName());
        }
        catch (LoadException e) {
            ServiceApplicationEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"validatePage()", (String)e.getMessage(), (Throwable)e, (boolean)false);
            return false;
        }
        if (application != null) {
            error = mTextPool.getText(2, (Object)application.getQualifiedName());
            this.setErrorMessage(error);
            return false;
        }
        error = CheckServices.isSourcePathValid((IPackageFragmentRoot)this.mData.getSelectedRoot());
        this.setErrorMessage(error);
        if (error != null) {
            return false;
        }
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mNameField != null) {
            this.mNameField.setFocus();
        }
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTextPool.getText(101);
        PAGE_DESCRIPTION = mTextPool.getText(102);
    }

    private class SourceSelectionListener
    implements SelectionListener {
        private SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = CreateApplicationWizardPropertiesPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = CreateApplicationWizardPropertiesPage.this.mData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                CreateApplicationWizardPropertiesPage.this.mData.setSelectedRoot(selectedRoot);
            }
            CreateApplicationWizardPropertiesPage.this.setPageComplete(CreateApplicationWizardPropertiesPage.this.validatePage());
        }
    }

    private class AuthenticationButtonSelectionListener
    implements SelectionListener {
        private AuthenticationButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            CreateApplicationWizardPropertiesPage.this.mData.setNeedsAuthentication(CreateApplicationWizardPropertiesPage.this.mAuthenticationButton.getSelection());
        }
    }

    private class PackageButtonSelectionListener
    implements SelectionListener {
        private PackageButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragmentRoot sourceRoot = CreateApplicationWizardPropertiesPage.this.mData.getSelectedRoot();
            String packageName = CreateApplicationWizardPropertiesPage.this.mData.getPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            IPackageFragment packageFragment = null;
            if (sourceRoot != null) {
                packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)CreateApplicationWizardPropertiesPage.this.getShell());
            }
            if (packageFragment != null) {
                CreateApplicationWizardPropertiesPage.this.mData.setPackage(packageFragment.getElementName());
                CreateApplicationWizardPropertiesPage.this.mPackageField.setText(packageFragment.getElementName());
            }
        }
    }

    private class PackageModifyListener
    implements ModifyListener {
        private PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CreateApplicationWizardPropertiesPage.this.mData.setPackage(CreateApplicationWizardPropertiesPage.this.mPackageField.getText());
            if (CreateApplicationWizardPropertiesPage.this.mComponentWizardData != null) {
                CreateApplicationWizardPropertiesPage.this.mComponentWizardData.setComponentPackage(CreateApplicationWizardPropertiesPage.this.mData.getPackage());
                CreateApplicationWizardPropertiesPage.this.mComponentWizardData.setWindowPackage(CreateApplicationWizardPropertiesPage.this.mData.getPackage());
            }
            CreateApplicationWizardPropertiesPage.this.setPageComplete(CreateApplicationWizardPropertiesPage.this.validatePage());
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CreateApplicationWizardPropertiesPage.this.mData.setName(CreateApplicationWizardPropertiesPage.this.mNameField.getText());
            if (CreateApplicationWizardPropertiesPage.this.mComponentWizardData != null) {
                CreateApplicationWizardPropertiesPage.this.mComponentWizardData.setComponentName(CreateApplicationWizardPropertiesPage.this.mData.getName());
                CreateApplicationWizardPropertiesPage.this.mComponentWizardData.setWindowName(CreateApplicationWizardPropertiesPage.this.mData.getName());
            }
            CreateApplicationWizardPropertiesPage.this.setPageComplete(CreateApplicationWizardPropertiesPage.this.validatePage());
        }
    }
}

