/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.wizards.application;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.ApplicationProperty;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinitionSet;
import com.sap.ide.webdynpro.applicationeditor.Plugin;
import com.sap.ide.webdynpro.applicationeditor.overview.ApplicationReferencesSectionData;
import com.sap.ide.webdynpro.applicationeditor.wizards.application.CreateApplicationWizardCreateOrReferenceSelectionPage;
import com.sap.ide.webdynpro.applicationeditor.wizards.application.CreateApplicationWizardData;
import com.sap.ide.webdynpro.applicationeditor.wizards.application.CreateApplicationWizardPropertiesPage;
import com.sap.ide.webdynpro.applicationeditor.wizards.application.CreateApplicationWizardReferencesPage;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceApplicationEditorPlugin;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.component.ComponentWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateApplicationWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private WebDynproRoot mWebDynproRoot = null;
    private CreateApplicationWizardData mPropertiesData = null;
    private CreateApplicationWizardCreateOrReferenceSelectionPage mCreateOrReferencePage = null;
    private ApplicationReferencesSectionData mReferencesData = null;
    private CreateApplicationWizardPropertiesPage mPropertiesPage = null;
    private CreateApplicationWizardReferencesPage mReferencesPage = null;
    private ComponentWizard mComponentWizard = null;

    public CreateApplicationWizard(WebDynproRoot root, CreateApplicationWizardData data) {
        this.mComponentWizard = new ComponentWizard(root);
        this.mWebDynproRoot = root;
        this.mPropertiesData = data == null ? new CreateApplicationWizardData(root) : data;
        this.setWindowTitle(mTextPool.getText(149));
    }

    public boolean performFinish() {
        Application application;
        IPackageFragmentRoot packageFragmentRoot = this.getData().getSelectedRoot();
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mWebDynproRoot.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
        SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
        try {
            application = ApplicationService.createApplication((WebDynproRoot)this.mWebDynproRoot, (String)this.mPropertiesData.getPackage().toLowerCase(), (String)this.mPropertiesData.getName(), (Component)this.mReferencesData.getSelectedComponent(), (InboundPlug)this.mReferencesData.getSelectedStartupPlug(), (SourcePathIdentifier)identifier);
        }
        catch (CreateException e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", e.getMessage(), e, true);
            this.mPropertiesPage.setMessage(e.getMessage());
            return false;
        }
        if (this.getData().isNeedsAuthentication()) {
            ApplicationPropertyDefinitionSet standard = null;
            try {
                standard = this.mWebDynproRoot.getApplicationPropertyDefinitionSet("com.sap.ide.webdynpro.applicationpropertydefs", "Standard");
            }
            catch (LoadException e) {
                ServiceApplicationEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)e.getMessage(), (Throwable)e, (boolean)false);
                return false;
            }
            if (standard != null) {
                ApplicationPropertyDefinition definition;
                if (!application.hasPropertyDefinitionSet(standard)) {
                    application.addPropertyDefinitionSet(standard);
                }
                if ((definition = standard.getPropertyDefinition("Authentication")) != null) {
                    ApplicationProperty property = null;
                    try {
                        property = application.createApplicationProperty(definition.getQualifiedName());
                    }
                    catch (CreateException e) {
                        ServiceApplicationEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"performFinish()", (String)e.getMessage(), (Throwable)e, (boolean)false);
                        return false;
                    }
                    if (property != null) {
                        property.setPropertyDefinition(definition);
                        property.setValue("true");
                    }
                }
            }
        }
        if (this.mPropertiesData.isCreateComponent()) {
            this.mComponentWizard.performFinish();
            Component component = this.mComponentWizard.getComponent();
            if (component != null) {
                InboundPlug[] inboundPlugs;
                application.setComponent(component);
                InterfaceView[] interfaceViews = component.getComponentInterface().getInterfaceViews();
                if (interfaceViews.length > 0 && (inboundPlugs = interfaceViews[0].getInboundPlugs()).length > 0) {
                    application.setStartupPlug(inboundPlugs[0]);
                }
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText(100));
        this.mComponentWizard.init(workbench, selection);
    }

    public void addPages() {
        String projectName = this.mPropertiesData.getWebDynproRoot().getMetamodel().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.mPropertiesPage = new CreateApplicationWizardPropertiesPage(this.mPropertiesData, this.mWebDynproRoot, this.mComponentWizard.getComponentWizardData());
        this.addPage((IWizardPage)this.mPropertiesPage);
        this.mCreateOrReferencePage = new CreateApplicationWizardCreateOrReferenceSelectionPage(this.mPropertiesData, this.mComponentWizard);
        this.addPage((IWizardPage)this.mCreateOrReferencePage);
        this.mReferencesData = new ApplicationReferencesSectionData(project);
        this.mReferencesPage = new CreateApplicationWizardReferencesPage(this.mReferencesData, project);
        this.mReferencesPage.setPageComplete(false);
        this.addPage((IWizardPage)this.mReferencesPage);
        this.mComponentWizard.addPages();
        IWizardPage[] componentWizardPages = this.mComponentWizard.getPages();
        int i = 0;
        while (i < componentWizardPages.length) {
            this.addPage(componentWizardPages[i]);
            ++i;
        }
    }

    public CreateApplicationWizardData getData() {
        return this.mPropertiesData;
    }

    public IWizardPage getComponentCreationPage() {
        return this.mComponentWizard.getStartingPage();
    }

    public IWizardPage getComponentReferencesPage() {
        return this.mReferencesPage;
    }

    public void setDialogSettings(IDialogSettings settings) {
        super.setDialogSettings(settings);
        this.mComponentWizard.setDialogSettings(settings);
    }

    public void dispose() {
        super.dispose();
        this.mComponentWizard.dispose();
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        this.mComponentWizard.setContainer(wizardContainer);
    }

    public boolean canFinish() {
        boolean finish = true;
        if (!this.mPropertiesPage.isPageComplete()) {
            finish = false;
        }
        if (!this.mCreateOrReferencePage.isPageComplete()) {
            finish = false;
        }
        if (this.getData().isCreateComponent()) {
            IWizardPage[] componentWizardPages = this.mComponentWizard.getPages();
            int i = 0;
            while (i < componentWizardPages.length) {
                if (!componentWizardPages[i].isPageComplete()) {
                    finish = false;
                    break;
                }
                ++i;
            }
        } else if (!this.mReferencesPage.isPageComplete()) {
            finish = false;
        }
        return finish;
    }
}

