/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.overview;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.enum.InboundPlugTypeEnum;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.webdynpro.applicationeditor.IDataUpdateListener;
import com.sap.ide.webdynpro.applicationeditor.Plugin;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class ApplicationReferencesSectionData {
    private IProject mProject = null;
    private Vector mUpdateListeners = new Vector();
    private ComponentObserver mComponentObserver = null;
    private int mSelectedComponent = -1;
    private int mSelectedInterfaceView = -1;
    private int mSelectedStartupPlug = -1;
    private WebDynproRoot mRoot = null;
    private Component[] mComponents = null;
    private InterfaceView[] mInterfaceViews = null;
    private InboundPlug[] mStartupPlugs = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$Component;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$view$InterfaceView;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$navigation$InboundPlug;

    public ApplicationReferencesSectionData(IProject project) {
        this.mProject = project;
        this.mRoot = WebDynproRootManager.getWebDynproRoot((Metamodel)MetamodelManager.getMetamodel((String)this.mProject.getName()));
        this.updateComponents();
        this.mComponentObserver = new ComponentObserver();
        this.mRoot.attachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$Component == null ? (class$com$sap$ide$metamodel$webdynpro$component$Component = ApplicationReferencesSectionData.class$("com.sap.ide.metamodel.webdynpro.component.Component")) : class$com$sap$ide$metamodel$webdynpro$component$Component, (DevelopmentObjectObserver)this.mComponentObserver, 3);
    }

    private void updateComponents() {
        try {
            this.mComponents = this.mRoot.getComponents();
        }
        catch (LoadException e) {
            Plugin.internalError(this.getClass(), "updateComponents()", e.getMessage(), e, false);
        }
        Arrays.sort(this.mComponents, new DevelopmentObjectNameComparator());
        this.updateInterfaceViews();
        this.mSelectedComponent = this.mComponents.length > 0 ? 0 : -1;
    }

    private void updateInterfaceViews() {
        if (this.mSelectedComponent > -1 & this.mSelectedComponent < this.mComponents.length) {
            Component component = this.mComponents[this.mSelectedComponent];
            this.mInterfaceViews = component.getComponentInterface().getInterfaceViews();
        } else {
            this.mInterfaceViews = new InterfaceView[0];
        }
        Arrays.sort(this.mInterfaceViews, new DevelopmentObjectNameComparator());
        this.updateStartupPlugs();
        this.mSelectedInterfaceView = this.mInterfaceViews.length > 0 ? 0 : -1;
    }

    private void updateStartupPlugs() {
        if (this.mSelectedInterfaceView > -1 & this.mSelectedInterfaceView < this.mInterfaceViews.length) {
            InterfaceView view = this.mInterfaceViews[this.mSelectedInterfaceView];
            InboundPlug[] plugs = view.getInboundPlugs();
            ArrayList<InboundPlug> array = new ArrayList<InboundPlug>();
            int i = 0;
            while (i < plugs.length) {
                if (plugs[i].getType().equals(InboundPlugTypeEnum.STARTUP)) {
                    array.add(plugs[i]);
                }
                ++i;
            }
            this.mStartupPlugs = new InboundPlug[array.size()];
            this.mStartupPlugs = array.toArray(this.mStartupPlugs);
        } else {
            this.mStartupPlugs = new InboundPlug[0];
        }
        Arrays.sort(this.mStartupPlugs, new DevelopmentObjectNameComparator());
        this.mSelectedStartupPlug = this.mStartupPlugs.length > 0 ? 0 : -1;
        this.fireDataUpdatedEvent();
    }

    public String[] getComponentNames() {
        String[] names = new String[this.mComponents.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.mComponents[i].getName() + " - " + this.mComponents[i].getPackage();
            ++i;
        }
        return names;
    }

    public String getSelectedComponentName() {
        if (this.mSelectedComponent > -1 & this.mSelectedComponent < this.mComponents.length) {
            return this.mComponents[this.mSelectedComponent].getName() + " - " + this.mComponents[this.mSelectedComponent].getPackage();
        }
        return "";
    }

    public Component getSelectedComponent() {
        if (this.mSelectedComponent > -1 && this.mSelectedComponent < this.mComponents.length) {
            return this.mComponents[this.mSelectedComponent];
        }
        return null;
    }

    public int getSelectedComponentIndex() {
        return this.mSelectedComponent;
    }

    public void setSelectedComponent(Component component) {
        boolean found = false;
        int i = 0;
        while (i < this.mComponents.length) {
            if (this.mComponents[i].equals(component)) {
                found = true;
                this.setSelectedComponent(i);
            }
            ++i;
        }
        if (!found) {
            this.setSelectedComponent(-1);
        }
    }

    public void setSelectedComponent(int index) {
        if (index > -1 & index < this.mComponents.length) {
            this.mSelectedComponent = index;
        }
        this.updateInterfaceViews();
    }

    public String[] getInterfaceViewNames() {
        String[] names = new String[this.mInterfaceViews.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.mInterfaceViews[i].getName();
            ++i;
        }
        return names;
    }

    public String getSelectedInterfaceViewName() {
        if (this.mSelectedInterfaceView > -1 & this.mSelectedInterfaceView < this.mInterfaceViews.length) {
            return this.mInterfaceViews[this.mSelectedInterfaceView].getName();
        }
        return "";
    }

    public InterfaceView getSelectedInterfaceView() {
        if (this.mSelectedInterfaceView > -1 && this.mSelectedInterfaceView < this.mInterfaceViews.length) {
            return this.mInterfaceViews[this.mSelectedInterfaceView];
        }
        return null;
    }

    public int getSelectedInterfaceViewIndex() {
        return this.mSelectedInterfaceView;
    }

    public void setSelectedInterfaceView(InterfaceView view) {
        boolean found = false;
        int i = 0;
        while (i < this.mInterfaceViews.length) {
            if (this.mInterfaceViews[i].equals(view)) {
                found = true;
                this.setSelectedInterfaceView(i);
            }
            ++i;
        }
        if (!found) {
            this.setSelectedInterfaceView(-1);
        }
    }

    public void setSelectedInterfaceView(int index) {
        if (index > -1 & index < this.mInterfaceViews.length) {
            this.mSelectedInterfaceView = index;
        }
        this.updateStartupPlugs();
    }

    public String[] getStartupPlugNames() {
        String[] names = new String[this.mStartupPlugs.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.mStartupPlugs[i].getName();
            ++i;
        }
        return names;
    }

    public String getSelectedStartupPlugName() {
        if (this.mSelectedStartupPlug > -1 & this.mSelectedStartupPlug < this.mStartupPlugs.length) {
            return this.mStartupPlugs[this.mSelectedStartupPlug].getName();
        }
        return "";
    }

    public int getSelectedStartupPlugIndex() {
        return this.mSelectedStartupPlug;
    }

    public InboundPlug getSelectedStartupPlug() {
        if (this.mSelectedStartupPlug > -1 && this.mSelectedStartupPlug < this.mStartupPlugs.length) {
            return this.mStartupPlugs[this.mSelectedStartupPlug];
        }
        return null;
    }

    public void setSelectedStartupPlug(InboundPlug plug) {
        boolean found = false;
        int i = 0;
        while (i < this.mStartupPlugs.length) {
            if (this.mStartupPlugs[i].equals(plug)) {
                found = true;
                this.setSelectedStartupPlug(i);
            }
            ++i;
        }
        if (!found) {
            this.setSelectedStartupPlug(-1);
        }
    }

    public void setSelectedStartupPlug(int index) {
        if (index > -1 & index < this.mStartupPlugs.length) {
            this.mSelectedStartupPlug = index;
            this.fireDataUpdatedEvent();
        }
    }

    public void dispose() {
        this.mRoot.detachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$Component == null ? (class$com$sap$ide$metamodel$webdynpro$component$Component = ApplicationReferencesSectionData.class$("com.sap.ide.metamodel.webdynpro.component.Component")) : class$com$sap$ide$metamodel$webdynpro$component$Component, (DevelopmentObjectObserver)this.mComponentObserver);
        this.mRoot.detachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$view$InterfaceView == null ? (class$com$sap$ide$metamodel$webdynpro$component$view$InterfaceView = ApplicationReferencesSectionData.class$("com.sap.ide.metamodel.webdynpro.component.view.InterfaceView")) : class$com$sap$ide$metamodel$webdynpro$component$view$InterfaceView, (DevelopmentObjectObserver)this.mComponentObserver);
        this.mRoot.detachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$navigation$InboundPlug == null ? (class$com$sap$ide$metamodel$webdynpro$component$navigation$InboundPlug = ApplicationReferencesSectionData.class$("com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug")) : class$com$sap$ide$metamodel$webdynpro$component$navigation$InboundPlug, (DevelopmentObjectObserver)this.mComponentObserver);
    }

    public void addUpdateListener(IDataUpdateListener listener) {
        if (!this.mUpdateListeners.contains(listener)) {
            this.mUpdateListeners.add(listener);
        }
    }

    public void removeUpdateListener(IDataUpdateListener listener) {
        if (this.mUpdateListeners.contains(listener)) {
            this.mUpdateListeners.remove(listener);
        }
    }

    private void fireDataUpdatedEvent() {
        Enumeration enumeration = this.mUpdateListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDataUpdateListener listener = (IDataUpdateListener)enumeration.nextElement();
            listener.dataUpdated();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ComponentObserver
    implements DevelopmentObjectObserver {
        private ComponentObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            Component selectedComponent = ApplicationReferencesSectionData.this.getSelectedComponent();
            InterfaceView view = ApplicationReferencesSectionData.this.getSelectedInterfaceView();
            InboundPlug plug = ApplicationReferencesSectionData.this.getSelectedStartupPlug();
            ApplicationReferencesSectionData.this.updateComponents();
            ApplicationReferencesSectionData.this.setSelectedComponent(selectedComponent);
            ApplicationReferencesSectionData.this.setSelectedInterfaceView(view);
            ApplicationReferencesSectionData.this.setSelectedStartupPlug(plug);
        }
    }
}

