/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.applicationeditor.IDataUpdateListener;
import com.sap.ide.webdynpro.applicationeditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.applicationeditor.overview.ApplicationReferencesSectionData;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class ApplicationReferencesEditUI
implements IDataUpdateListener {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Application mApplication = null;
    private ApplicationReferencesSectionData mData = null;
    private IDisplayErrorListener mDisplayErrorListener = null;
    private Combo mComponentField = null;
    private Combo mInterfaceViewField = null;
    private Combo mStartupPlugField = null;

    public ApplicationReferencesEditUI(ApplicationReferencesSectionData data, IDisplayErrorListener displayErrorListener) {
        this(data, null, displayErrorListener);
    }

    public ApplicationReferencesEditUI(ApplicationReferencesSectionData data, Application application, IDisplayErrorListener displayErrorListener) {
        this.mData = data;
        this.mApplication = application;
        this.mDisplayErrorListener = displayErrorListener;
        this.mData.addUpdateListener(this);
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mCoreTextPool.getText(111));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mComponentField = glp.addComboBox(this.mData.getComponentNames(), this.mData.getSelectedComponentName(), true, gd);
        this.mComponentField.addSelectionListener((SelectionListener)new ComponentSelectionListener());
        glp.addTextLabel(mTextPool.getText(111));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mInterfaceViewField = glp.addComboBox(this.mData.getInterfaceViewNames(), this.mData.getSelectedInterfaceViewName(), true, gd);
        this.mInterfaceViewField.addSelectionListener((SelectionListener)new InterfaceViewSelectionListener());
        glp.addTextLabel(mTextPool.getText(110));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mStartupPlugField = glp.addComboBox(this.mData.getStartupPlugNames(), this.mData.getSelectedStartupPlugName(), true, gd);
        this.mStartupPlugField.addSelectionListener((SelectionListener)new StartupPlugSelectionListener());
        if (this.mApplication != null) {
            boolean enable = !this.mApplication.originatesInArchive();
            this.mComponentField.setEnabled(enable);
            this.mInterfaceViewField.setEnabled(enable);
            this.mStartupPlugField.setEnabled(enable);
        }
    }

    public boolean validatePage() {
        if (this.mDisplayErrorListener == null) {
            return true;
        }
        if (this.mData.getSelectedComponent() == null) {
            this.mDisplayErrorListener.setErrorMessage(mTextPool.getText(5));
            this.mDisplayErrorListener.setPageComplete(false);
            return false;
        }
        this.mDisplayErrorListener.setErrorMessage(null);
        if (this.mData.getSelectedInterfaceView() == null) {
            this.mDisplayErrorListener.setErrorMessage(mTextPool.getText(6));
            this.mDisplayErrorListener.setPageComplete(false);
            return false;
        }
        this.mDisplayErrorListener.setErrorMessage(null);
        if (this.mData.getSelectedStartupPlug() == null) {
            this.mDisplayErrorListener.setErrorMessage(mTextPool.getText(7));
            this.mDisplayErrorListener.setPageComplete(false);
            return false;
        }
        this.mDisplayErrorListener.setErrorMessage(null);
        this.mDisplayErrorListener.setPageComplete(true);
        return true;
    }

    public void dataUpdated() {
        if (!this.mComponentField.isDisposed()) {
            this.mComponentField.setItems(this.mData.getComponentNames());
            this.mComponentField.select(this.mData.getSelectedComponentIndex());
        }
        if (!this.mInterfaceViewField.isDisposed()) {
            this.mInterfaceViewField.setItems(this.mData.getInterfaceViewNames());
            this.mInterfaceViewField.select(this.mData.getSelectedInterfaceViewIndex());
        }
        if (!this.mStartupPlugField.isDisposed()) {
            this.mStartupPlugField.setItems(this.mData.getStartupPlugNames());
            this.mStartupPlugField.select(this.mData.getSelectedStartupPlugIndex());
        }
    }

    public void dispose() {
        this.mData.removeUpdateListener(this);
    }

    private class StartupPlugSelectionListener
    implements SelectionListener {
        private StartupPlugSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (ApplicationReferencesEditUI.this.mData.getSelectedStartupPlugIndex() != ApplicationReferencesEditUI.this.mStartupPlugField.getSelectionIndex()) {
                MMRepositoryObject[] repositoryObjects;
                if (ApplicationReferencesEditUI.this.mApplication != null && !RepositoryServices.checkWriteability((MMRepositoryObject[])(repositoryObjects = ApplicationService.getRepositoryObjectsAffectedByApplicationModification((Application)ApplicationReferencesEditUI.this.mApplication)))) {
                    ApplicationReferencesEditUI.this.mStartupPlugField.select(ApplicationReferencesEditUI.this.mData.getSelectedStartupPlugIndex());
                    return;
                }
                ApplicationReferencesEditUI.this.mData.setSelectedStartupPlug(ApplicationReferencesEditUI.this.mStartupPlugField.getSelectionIndex());
                if (ApplicationReferencesEditUI.this.mApplication != null && !ApplicationReferencesEditUI.this.mData.getSelectedStartupPlug().equals(ApplicationReferencesEditUI.this.mApplication.getStartupPlug())) {
                    ApplicationReferencesEditUI.this.mApplication.setStartupPlug(ApplicationReferencesEditUI.this.mData.getSelectedStartupPlug());
                }
                ApplicationReferencesEditUI.this.validatePage();
            }
        }
    }

    private class InterfaceViewSelectionListener
    implements SelectionListener {
        private InterfaceViewSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (ApplicationReferencesEditUI.this.mData.getSelectedInterfaceViewIndex() != ApplicationReferencesEditUI.this.mInterfaceViewField.getSelectionIndex()) {
                MMRepositoryObject[] repositoryObjects;
                if (ApplicationReferencesEditUI.this.mApplication != null && !RepositoryServices.checkWriteability((MMRepositoryObject[])(repositoryObjects = ApplicationService.getRepositoryObjectsAffectedByApplicationModification((Application)ApplicationReferencesEditUI.this.mApplication)))) {
                    ApplicationReferencesEditUI.this.mInterfaceViewField.select(ApplicationReferencesEditUI.this.mData.getSelectedInterfaceViewIndex());
                    return;
                }
                ApplicationReferencesEditUI.this.mData.setSelectedInterfaceView(ApplicationReferencesEditUI.this.mInterfaceViewField.getSelectionIndex());
                if (ApplicationReferencesEditUI.this.mApplication != null) {
                    ApplicationReferencesEditUI.this.mApplication.setStartupPlug(ApplicationReferencesEditUI.this.mData.getSelectedStartupPlug());
                }
                ApplicationReferencesEditUI.this.validatePage();
            }
        }
    }

    private class ComponentSelectionListener
    implements SelectionListener {
        private ComponentSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (ApplicationReferencesEditUI.this.mData.getSelectedComponentIndex() != ApplicationReferencesEditUI.this.mComponentField.getSelectionIndex()) {
                MMRepositoryObject[] repositoryObjects;
                if (ApplicationReferencesEditUI.this.mApplication != null && !RepositoryServices.checkWriteability((MMRepositoryObject[])(repositoryObjects = ApplicationService.getRepositoryObjectsAffectedByApplicationModification((Application)ApplicationReferencesEditUI.this.mApplication)))) {
                    ApplicationReferencesEditUI.this.mComponentField.select(ApplicationReferencesEditUI.this.mData.getSelectedComponentIndex());
                    return;
                }
                ApplicationReferencesEditUI.this.mData.setSelectedComponent(ApplicationReferencesEditUI.this.mComponentField.getSelectionIndex());
                if (ApplicationReferencesEditUI.this.mApplication != null) {
                    ApplicationReferencesEditUI.this.mApplication.setComponent(ApplicationReferencesEditUI.this.mData.getSelectedComponent());
                    ApplicationReferencesEditUI.this.mApplication.setStartupPlug(ApplicationReferencesEditUI.this.mData.getSelectedStartupPlug());
                }
                ApplicationReferencesEditUI.this.validatePage();
            }
        }
    }
}

